/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.compat.jei;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingRecipe;
import com.atsuishio.superbwarfare.recipe.vehicle.VehicleAssemblingResult;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VehicleAssemblingCategory
implements IRecipeCategory<VehicleAssemblingRecipe> {
    public static final ResourceLocation TEXTURE = Mod.loc("textures/gui/jei_vehicle_assembling_table.png");
    public static final RecipeType<VehicleAssemblingRecipe> TYPE = new RecipeType(Mod.loc("vehicle_assembling"), VehicleAssemblingRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public VehicleAssemblingCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 144, 36).setTextureSize(144, 36).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItems.VEHICLE_ASSEMBLING_TABLE.get()));
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public RecipeType<VehicleAssemblingRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.translatable((String)"jei.superbwarfare.vehicle_assembling");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 36;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VehicleAssemblingRecipe recipe, @NotNull IFocusGroup focuses) {
        VehicleAssemblingResult res = recipe.getResult();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 1, 1).addItemStack(res.getResult().copyWithCount(res.count));
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            if (i >= 12) {
                return;
            }
            ItemStack[] ingredient = recipe.getInputs().get(i).getIngredient().getItems();
            int finalI = i;
            Arrays.stream(ingredient).forEach(stack -> stack.setCount(recipe.getInputs().get(finalI).getCount()));
            builder.addSlot(RecipeIngredientRole.INPUT, 37 + i % 6 * 18, 1 + i / 6 * 18).addItemStacks(List.of(ingredient));
        }
    }
}

