/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.gun.subdata;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.IntValue;
import com.atsuishio.superbwarfare.data.gun.value.ReloadState;
import com.atsuishio.superbwarfare.data.gun.value.Starter;
import com.atsuishio.superbwarfare.data.gun.value.Timer;
import net.minecraft.nbt.CompoundTag;

public final class Reload {
    private final CompoundTag data;
    public final Timer reloadTimer;
    public final Timer prepareTimer;
    public final Timer prepareLoadTimer;
    public final Timer iterativeLoadTimer;
    public final Timer finishTimer;
    public final Starter reloadStarter;
    public final Starter singleReloadStarter;
    public final Starter stage3Starter;
    public final IntValue stage;

    public Reload(GunData data) {
        this.data = data.data();
        this.reloadTimer = new Timer(this.data, "Reload");
        this.prepareTimer = new Timer(this.data, "Prepare");
        this.prepareLoadTimer = new Timer(this.data, "PrepareLoad");
        this.iterativeLoadTimer = new Timer(this.data, "IterativeLoad");
        this.finishTimer = new Timer(this.data, "Finish");
        this.reloadStarter = new Starter(this.data, "Reload");
        this.singleReloadStarter = new Starter(this.data, "SingleReload");
        this.stage3Starter = new Starter(this.data, "Stage3Forcefully");
        this.stage = new IntValue(this.data, "ReloadStage");
    }

    public ReloadState state() {
        return switch (this.data.getInt("ReloadState")) {
            case 1 -> ReloadState.NORMAL_RELOADING;
            case 2 -> ReloadState.EMPTY_RELOADING;
            default -> ReloadState.NOT_RELOADING;
        };
    }

    public boolean normal() {
        return this.state() == ReloadState.NORMAL_RELOADING;
    }

    public boolean empty() {
        return this.state() == ReloadState.EMPTY_RELOADING;
    }

    public void setState(ReloadState state) {
        if (state == ReloadState.NOT_RELOADING) {
            this.data.remove("ReloadState");
        } else {
            this.data.putInt("ReloadState", state.ordinal());
        }
    }

    public int stage() {
        return this.stage.get();
    }

    public void setStage(int stage) {
        this.stage.set(stage);
    }

    public int time() {
        return this.reloadTimer.get();
    }

    public void setTime(int time) {
        this.reloadTimer.set(time);
    }

    public void reduce() {
        this.reloadTimer.reduce();
    }
}

