/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.data.vehicle.subdata;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleEngineUtils;
import com.google.gson.annotations.SerializedName;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class EngineInfo {
    @SerializedName(value="EnergyCostRate")
    public double energyCostRate = 1.0;
    @SerializedName(value="Buoyancy")
    public double buoyancy = 0.0;
    @SerializedName(value="Increment")
    public float increment = 0.001f;
    @SerializedName(value="Decrement")
    public float decrement = 0.001f;
    @SerializedName(value="EngineSoundVolume")
    public float engineSoundVolume = 0.4f;

    public abstract void work(VehicleEntity var1);

    public static class Tom6
    extends Aircraft {
        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.tomEngine(vehicle, this);
        }
    }

    public static class Aircraft
    extends Helicopter {
        @SerializedName(value="SpeedRate")
        public float speedRate = 1.0f;
        @SerializedName(value="GearRotateAngle")
        public float gearRotateAngle = 85.0f;
        @SerializedName(value="HasGear")
        public boolean hasGear = true;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.aircraftEngine(vehicle, this);
        }
    }

    public static class Helicopter
    extends EngineInfo {
        @SerializedName(value="PitchSpeed")
        public float pitchSpeed = 1.0f;
        @SerializedName(value="YawSpeed")
        public float yawSpeed = 1.0f;
        @SerializedName(value="RollSpeed")
        public float rollSpeed = 1.0f;
        @SerializedName(value="LiftSpeed")
        public float liftSpeed = 1.0f;
        @SerializedName(value="EngineStartSound")
        public SoundEvent engineStartSound = SoundEvents.EMPTY;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.helicopterEngine(vehicle, this);
        }
    }

    public static class Ship
    extends EngineInfo {
        @SerializedName(value="BodyPitchRate")
        public double bodyPitchRate = 1.0;
        @SerializedName(value="BodyRollRate")
        public double bodyRollRate = 1.0;
        @SerializedName(value="SteeringSpeed")
        public float steeringSpeed = 0.1f;
        @SerializedName(value="MaxForwardSpeedRate")
        public float maxForwardSpeedRate = 0.2f;
        @SerializedName(value="MaxBackwardSpeedRate")
        public float maxBackwardSpeedRate = -0.1f;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.shipEngine(vehicle, this);
        }
    }

    public static class WheelChair
    extends Wheel {
        @SerializedName(value="BodyRollRate")
        public double bodyRollRate = 1.0;
        @SerializedName(value="CanJump")
        public boolean canJump = false;
        @SerializedName(value="JumpEnergyCost")
        public int jumpEnergyCost = 400;
        @SerializedName(value="JumpCoolDown")
        public int jumpCoolDown = 3;
        @SerializedName(value="JumpForce")
        public double jumpForce = 0.6;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.wheelChairEngine(vehicle, this);
        }
    }

    public static class Track
    extends Wheel {
        @SerializedName(value="TrackRotSpeed")
        public double trackRotSpeed = 0.0;
        @SerializedName(value="TrackDifferential")
        public double trackDifferential = 0.0;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.trackEngine(vehicle, this);
        }
    }

    public static class Wheel
    extends EngineInfo {
        @SerializedName(value="WheelRotSpeed")
        public double wheelRotSpeed = 0.0;
        @SerializedName(value="WheelDifferential")
        public double wheelDifferential = 0.0;
        @SerializedName(value="SteeringSpeed")
        public float steeringSpeed = 0.1f;
        @SerializedName(value="MaxForwardSpeedRate")
        public float maxForwardSpeedRate = 0.2f;
        @SerializedName(value="MaxBackwardSpeedRate")
        public float maxBackwardSpeedRate = -0.1f;

        @Override
        public void work(VehicleEntity vehicle) {
            VehicleEngineUtils.wheelEngine(vehicle, this);
        }
    }
}

