/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.FastThrowableProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class DestroyableProjectile
extends FastThrowableProjectile
implements CustomSyncMotionEntity {
    public static final EntityDataAccessor<Float> HEALTH = SynchedEntityData.defineId(DestroyableProjectile.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final DamageModifier DAMAGE_MODIFIER = DamageModifier.createDefaultModifier();

    public DestroyableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public DestroyableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.setOwner(pShooter);
        if (pShooter != null) {
            this.setPos(pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        }
    }

    public boolean isPickable() {
        return !this.isRemoved();
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        amount = DAMAGE_MODIFIER.compute(source, amount);
        this.entityData.set(HEALTH, (Object)Float.valueOf(((Float)this.entityData.get(HEALTH)).floatValue() - amount));
        return super.hurt(source, amount);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEALTH, (Object)Float.valueOf(this.getMaxHealth()));
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Health")) {
            this.entityData.set(HEALTH, (Object)Float.valueOf(compound.getFloat("Health")));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("Health", ((Float)this.entityData.get(HEALTH)).floatValue());
    }

    public float getMaxHealth() {
        return 30.0f;
    }
}

