/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.config.server.ExplosionConfig;
import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.ChunkLoadManager;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class FastThrowableProjectile
extends ThrowableItemProjectile
implements CustomSyncMotionEntity,
IEntityWithComplexSpawn,
ExplosiveProjectile {
    public static Consumer<FastThrowableProjectile> playFlySound = projectile -> {};
    public static Consumer<FastThrowableProjectile> playNearFlySound = projectile -> {};
    private static final int CHUNK_RADIUS = 1;
    public float damage = 0.0f;
    public float explosionDamage = 0.0f;
    public float explosionRadius = 0.0f;
    public int durability = 50;
    public boolean firstHit = true;
    public float gravity = 0.05f;
    private boolean isFastMoving = false;
    private final Set<ChunkPos> currentChunks = new HashSet<ChunkPos>();
    private ChunkPos lastChunkPos;

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, double pX, double pY, double pZ, Level pLevel) {
        super(pEntityType, pX, pY, pZ, pLevel);
    }

    public FastThrowableProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.setOwner(pShooter);
        if (pShooter != null) {
            this.setPos(pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        }
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Damage")) {
            this.damage = compound.getFloat("Damage");
        }
        if (compound.contains("ExplosionDamage")) {
            this.explosionDamage = compound.getFloat("ExplosionDamage");
        }
        if (compound.contains("Radius")) {
            this.explosionRadius = compound.getFloat("Radius");
        }
        if (compound.contains("Durability")) {
            this.durability = compound.getInt("Durability");
        }
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.damage > 0.0f) {
            compound.putFloat("Damage", this.damage);
        }
        if (this.explosionDamage > 0.0f) {
            compound.putFloat("ExplosionDamage", this.explosionDamage);
        }
        if (this.explosionRadius > 0.0f) {
            compound.putFloat("Radius", this.explosionRadius);
        }
        if (this.durability > 0) {
            compound.putInt("Durability", this.durability);
        }
    }

    public void tick() {
        Level level;
        super.tick();
        if (!this.isFastMoving && this.isFastMoving() && this.level().isClientSide) {
            playFlySound.accept(this);
            playNearFlySound.accept(this);
        }
        this.isFastMoving = this.isFastMoving();
        Vec3 vec3 = this.getDeltaMovement();
        float friction = this.isInWater() ? 0.8f : 0.99f;
        vec3 = vec3.add(0.0, this.getGravity(), 0.0);
        this.setDeltaMovement(vec3.scale((double)(1.0f / friction)));
        this.applyGravity();
        this.syncMotion();
        if (!this.level().isClientSide && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.forceLoadChunk()) {
                this.updateChunkLoading(serverLevel);
            }
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult pResult) {
        super.onHitEntity(pResult);
        NeoForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitEntity(this.getOwner(), (Projectile)this, pResult.getEntity(), pResult.getLocation()));
    }

    protected void onHitBlock(@NotNull BlockHitResult pResult) {
        super.onHitBlock(pResult);
        NeoForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitBlock(pResult.getBlockPos(), this.level().getBlockState(pResult.getBlockPos()), pResult.getDirection(), this.getOwner(), (Projectile)this, pResult.getLocation()));
    }

    public void destroyBlock() {
        if (((Boolean)ExplosionConfig.EXPLOSION_DESTROY.get()).booleanValue()) {
            Vec3 posO = new Vec3(this.xo, this.yo, this.zo);
            List<BlockPos> blockList = TraceTool.getBlocksAlongRay(posO, this.getDeltaMovement(), this.getDeltaMovement().length());
            for (BlockPos pos : blockList) {
                BlockState blockState = this.level().getBlockState(pos);
                if (blockState.is(Blocks.AIR)) continue;
                float hardness = this.level().getBlockState(pos).getBlock().defaultDestroyTime();
                double resistance = 1.0 - Mth.clamp((double)(hardness / 100.0f), (double)0.0, (double)0.8);
                this.setDeltaMovement(this.getDeltaMovement().multiply(resistance, resistance, resistance));
                if (blockState.canOcclude()) {
                    this.durability -= 10 + (int)(0.5 * (double)hardness);
                }
                if (hardness <= (float)this.durability && hardness != -1.0f && ((Boolean)ExplosionConfig.EXTRA_EXPLOSION_EFFECT.get()).booleanValue()) {
                    this.level().destroyBlock(pos, true);
                }
                if (hardness != -1.0f && !(hardness > (float)this.durability) && this.durability > 0) continue;
                this.causeExplode(pos.getCenter());
                this.discard();
                break;
            }
        }
    }

    public CustomExplosion.Builder buildExplosion(Vec3 vec3) {
        return new CustomExplosion.Builder((Entity)this).attacker(this.getOwner()).damage(this.explosionDamage).radius(this.explosionRadius).position(vec3).withParticleType(this.explosionParticleType(this.explosionRadius));
    }

    public void causeExplode(Vec3 vec3) {
        this.buildExplosion(vec3).explode();
        if (this.discardAfterExplode()) {
            this.discard();
        }
    }

    public ParticleTool.ParticleType explosionParticleType(float radius) {
        ParticleTool.ParticleType particleType = radius <= 4.0f ? ParticleTool.ParticleType.SMALL : (radius > 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        return particleType;
    }

    public boolean discardAfterExplode() {
        return false;
    }

    private void updateChunkLoading(ServerLevel serverLevel) {
        ChunkPos currentPos = new ChunkPos(this.blockPosition());
        if (this.lastChunkPos != null && this.lastChunkPos.equals((Object)currentPos)) {
            return;
        }
        HashSet<ChunkPos> neededChunks = new HashSet<ChunkPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                neededChunks.add(new ChunkPos(currentPos.x + x, currentPos.z + z));
            }
        }
        HashSet<ChunkPos> toRelease = new HashSet<ChunkPos>(this.currentChunks);
        toRelease.removeAll(neededChunks);
        for (ChunkPos pos : toRelease) {
            ChunkLoadManager.releaseChunk(serverLevel, pos);
            this.currentChunks.remove(pos);
        }
        for (ChunkPos pos : neededChunks) {
            if (this.currentChunks.contains(pos)) continue;
            ChunkLoadManager.forceChunk(serverLevel, pos);
            this.currentChunks.add(pos);
        }
        this.lastChunkPos = currentPos;
    }

    public void remove(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.RemovalReason reason) {
        Object object;
        if (!this.level().isClientSide && (object = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)object;
            for (ChunkPos pos : this.currentChunks) {
                ChunkLoadManager.releaseChunk(serverLevel, pos);
            }
            this.currentChunks.clear();
        }
        super.remove(reason);
    }

    @Override
    public void syncMotion() {
        if (this.level().isClientSide) {
            return;
        }
        if (!this.shouldSyncMotion()) {
            return;
        }
        if (this.tickCount % this.getType().updateInterval() == 0) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isFastMoving() {
        return this.getDeltaMovement().length() >= 0.5;
    }

    public boolean shouldSyncMotion() {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        Vec3 motion = this.getDeltaMovement();
        buffer.writeFloat((float)motion.x);
        buffer.writeFloat((float)motion.y);
        buffer.writeFloat((float)motion.z);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.setDeltaMovement(additionalData.readFloat(), additionalData.readFloat(), additionalData.readFloat());
    }

    @NotNull
    public SoundEvent getSound() {
        return SoundEvents.EMPTY;
    }

    public float getVolume() {
        return 0.5f;
    }

    public boolean forceLoadChunk() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return true;
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public double getDefaultGravity() {
        return this.gravity;
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public void largeTrail() {
        if (this.level().isClientSide && this.tickCount > 2) {
            double l = this.getDeltaMovement().length();
            for (double i = 0.0; i < l; i += 2.0) {
                Vec3 startPos = new Vec3(this.xo, this.yo, this.zo);
                Vec3 pos = startPos.add(this.getDeltaMovement().normalize().scale(-i));
                this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, pos.x, pos.y, pos.z, 0.0, 0.0, 0.0);
            }
        }
    }

    public void mediumTrail() {
        if (this.level().isClientSide && this.tickCount > 2) {
            double l = this.getDeltaMovement().length();
            for (double i = 0.0; i < l; i += 2.0) {
                Vec3 startPos = new Vec3(this.xo, this.yo, this.zo);
                Vec3 pos = startPos.add(this.getDeltaMovement().normalize().scale(-i));
                float random = this.random.nextFloat();
                this.level().addParticle((ParticleOptions)new CustomCloudOption(0.6f, 0.58f, 0.57f, (int)(120.0f + 40.0f * random), 1.5f + 0.5f * random, 0.0f, false, false), pos.x + (double)(0.25f * random), pos.y + (double)(0.25f * random), pos.z + (double)(0.25f * random), 0.0, 0.0, 0.0);
            }
        }
    }

    public void smallTrail() {
        if (this.level().isClientSide && this.tickCount > 2) {
            double l = this.getDeltaMovement().length();
            for (double i = 0.0; i < l; i += 2.0) {
                Vec3 startPos = new Vec3(this.xo, this.yo, this.zo);
                Vec3 pos = startPos.add(this.getDeltaMovement().normalize().scale(-i));
                float random = this.random.nextFloat();
                this.level().addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.SMOKE, true, pos.x + (double)(0.25f * random), pos.y + (double)(0.25f * random), pos.z + (double)(0.25f * random), 0.0, 0.0, 0.0);
            }
        }
    }
}

