/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class MissileProjectile
extends DestroyableProjectile
implements CustomSyncMotionEntity {
    public static final EntityDataAccessor<String> TARGET_UUID = SynchedEntityData.defineId(MissileProjectile.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public Vec3 targetPos;
    public int guideType = 0;
    public boolean distracted = false;
    public boolean lost = false;
    public boolean lostTarget = false;

    public MissileProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public MissileProjectile(EntityType<? extends ThrowableItemProjectile> pEntityType, @Nullable Entity pShooter, Level pLevel) {
        super(pEntityType, pLevel);
        this.setOwner(pShooter);
        if (pShooter != null) {
            this.setPos(pShooter.getX(), pShooter.getEyeY() - (double)0.1f, pShooter.getZ());
        }
    }

    public void setTargetUuid(String uuid) {
        this.entityData.set(TARGET_UUID, (Object)uuid);
    }

    public void setGuideType(int guideType) {
        this.guideType = guideType;
    }

    public void setTargetVec(Vec3 targetPos) {
        if (targetPos != null) {
            this.targetPos = targetPos;
        }
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TARGET_UUID, (Object)"none");
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("TargetUuid")) {
            this.entityData.set(TARGET_UUID, (Object)compound.getString("TargetUuid"));
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("TargetUuid", (String)this.entityData.get(TARGET_UUID));
    }

    protected void updateRotation() {
    }

    public void turn(Vec3 vec3, float turnSpeed) {
        Vec3 v0 = this.getDeltaMovement().normalize();
        vec3 = vec3.add(v0.scale(-0.4));
        double d0 = vec3.horizontalDistance();
        float targetAngleY = (float)(-Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875);
        float targetAngleX = (float)(-Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875);
        float diffY = Mth.wrapDegrees((float)(targetAngleY - this.getYRot()));
        float diffX = Mth.wrapDegrees((float)(targetAngleX - this.getXRot()));
        this.setYRot(this.getYRot() + Mth.clamp((float)(0.95f * diffY), (float)(-turnSpeed), (float)turnSpeed));
        this.setXRot(this.getXRot() + Mth.clamp((float)(0.95f * diffX), (float)(-turnSpeed), (float)turnSpeed));
    }

    public void shoot(double pX, double pY, double pZ, float pVelocity, float pInaccuracy) {
        Vec3 vec3 = new Vec3(pX, pY, pZ).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy), this.random.triangle(0.0, 0.0172275 * (double)pInaccuracy)).scale((double)pVelocity);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(-Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(-Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }

    @Override
    public boolean forceLoadChunk() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }

    @Override
    public double getDefaultGravity() {
        return 0.0;
    }
}

