/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.entity.projectile.DestroyableProjectile;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.ProjectileTool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Mk82Entity
extends DestroyableProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Mk82Entity(EntityType<? extends Mk82Entity> type, Level level) {
        super(type, level);
        this.noCulling = true;
        this.explosionRadius = 22.0f;
        this.explosionDamage = 650.0f;
    }

    @Override
    public boolean hurt(@NotNull DamageSource source, float amount) {
        Mk82Entity mk82Entity;
        Entity entity = source.getDirectEntity();
        if (entity instanceof Mk82Entity && (mk82Entity = (Mk82Entity)entity).getOwner() == this.getOwner()) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ModItems.MEDIUM_AERIAL_BOMB.get();
    }

    @Override
    public void onHitBlock(@NotNull BlockHitResult blockHitResult) {
        super.onHitBlock(blockHitResult);
        if (this.level() instanceof ServerLevel) {
            ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
        }
        this.discard();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tickCount > 600 || ((Float)this.entityData.get(HEALTH)).floatValue() <= 0.0f) {
            if (!this.level().isClientSide) {
                ProjectileTool.causeCustomExplode((ThrowableItemProjectile)this, this.explosionDamage, this.explosionRadius, 1.2f);
            }
            this.discard();
        }
    }

    private PlayState movementPredicate(AnimationState<Mk82Entity> event) {
        return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("animation.mk_82.start"));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 0, this::movementPredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    @NotNull
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.SHELL_FLY.get();
    }

    @Override
    public float getVolume() {
        return 0.7f;
    }

    @Override
    public boolean shouldSyncMotion() {
        return true;
    }
}

