/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.projectile;

import com.atsuishio.superbwarfare.api.event.ProjectileHitEvent;
import com.atsuishio.superbwarfare.client.particle.BulletDecalOption;
import com.atsuishio.superbwarfare.client.particle.CustomCloudOption;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.config.server.ProjectileConfig;
import com.atsuishio.superbwarfare.entity.DPSGeneratorEntity;
import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.ICustomKnockback;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.entity.projectile.CustomSyncMotionEntity;
import com.atsuishio.superbwarfare.entity.projectile.ExplosiveProjectile;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.Beast;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.ClientMotionSyncMessage;
import com.atsuishio.superbwarfare.tools.CustomExplosion;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.HitboxHelper;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.atsuishio.superbwarfare.world.phys.EntityResult;
import com.atsuishio.superbwarfare.world.phys.ExtendedEntityRayTraceResult;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ProjectileEntity
extends Projectile
implements GeoEntity,
CustomSyncMotionEntity,
ExplosiveProjectile {
    public static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.defineId(ProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final Predicate<Entity> PROJECTILE_TARGETS = input -> input != null && input.isPickable() && !input.isSpectator() && input.isAlive();
    private static final Predicate<BlockState> IGNORE_LIST = input -> input != null && input.is(ModTags.Blocks.BULLET_IGNORE) && !input.is(Blocks.IRON_DOOR) && !input.is(Blocks.IRON_TRAPDOOR);
    public static final float DEFAULT_R = 1.0f;
    public static final float DEFAULT_G = 0.87058824f;
    public static final float DEFAULT_B = 0.15294118f;
    @Nullable
    protected Entity shooter;
    protected int shooterId;
    private float damage = 1.0f;
    private float headShot = 1.0f;
    private float legShot = 0.5f;
    private boolean beast = false;
    private boolean zoom = false;
    private float bypassArmorRate = 0.0f;
    private float explosionDamage = 0.0f;
    private float explosionRadius = 0.0f;
    private int fireLevel = 0;
    private boolean dragonBreath = false;
    private float knockback = 0.05f;
    private float velocity = 20.0f;
    private boolean forceKnockback = false;
    private boolean penetrating = false;
    private final ArrayList<MobEffectInstance> mobEffects = new ArrayList();
    private String gunItemId;
    private float gravity = 0.05f;

    public ProjectileEntity(EntityType<? extends ProjectileEntity> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public ProjectileEntity(Level level) {
        this((EntityType<? extends ProjectileEntity>)((EntityType)ModEntities.PROJECTILE.get()), level);
    }

    @Nullable
    protected EntityResult findEntityOnPath(Vec3 startVec, Vec3 endVec) {
        Vec3 hitVec = null;
        Entity hitEntity = null;
        boolean headshot = false;
        boolean legShot = false;
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(this.beast ? 3.0 : 1.0), PROJECTILE_TARGETS);
        double closestDistance = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceToHit;
            Vec3 hitPos;
            EntityResult result;
            if (entity.equals((Object)this.shooter) || this.shooter != null && entity.equals((Object)this.shooter.getVehicle()) || entity instanceof TargetEntity && (Integer)entity.getEntityData().get(TargetEntity.DOWN_TIME) > 0 || entity instanceof DPSGeneratorEntity && (Integer)entity.getEntityData().get(DPSGeneratorEntity.DOWN_TIME) > 0 || (result = this.getHitResult(entity, startVec, endVec)) == null || (hitPos = result.getHitPos()) == null || !((distanceToHit = startVec.distanceTo(hitPos)) < closestDistance)) continue;
            hitVec = hitPos;
            hitEntity = entity;
            closestDistance = distanceToHit;
            headshot = result.isHeadshot();
            legShot = result.isLegShot();
        }
        return hitEntity != null ? new EntityResult(hitEntity, hitVec, headshot, legShot) : null;
    }

    @Nullable
    protected List<EntityResult> findEntitiesOnPath(Vec3 startVec, Vec3 endVec) {
        ArrayList<EntityResult> hitEntities = new ArrayList<EntityResult>();
        List entities = this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), PROJECTILE_TARGETS);
        for (Entity entity : entities) {
            EntityResult result;
            if (this.shooter != null && (entity == this.shooter || entity == this.shooter.getVehicle()) || (result = this.getHitResult(entity, startVec, endVec)) == null || entity.getVehicle() != null && this.shooter != null && entity.getVehicle() == this.shooter.getVehicle()) continue;
            hitEntities.add(result);
        }
        return hitEntities;
    }

    @Nullable
    private EntityResult getHitResult(Entity entity, Vec3 startVec, Vec3 endVec) {
        OBBEntity obbEntity;
        double expandHeight = entity instanceof Player && !entity.isCrouching() ? 0.0625 : 0.0;
        Vec3 hitPos = null;
        if (entity instanceof OBBEntity && !(obbEntity = (OBBEntity)entity).enableAABB()) {
            for (OBB obb : obbEntity.getOBBs()) {
                Vector3d obbVec = obb.clip(OBB.vec3ToVector3d(startVec), OBB.vec3ToVector3d(endVec)).orElse(null);
                if (obbVec == null) continue;
                hitPos = OBB.vector3dToVec3(obbVec);
                Level level = this.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    this.level().playSound(null, BlockPos.containing((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.2, false);
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.01, false);
                }
                OBBHitter acc = OBBHitter.getInstance((Entity)this);
                acc.sbw$setCurrentHitPart(obb.part());
            }
        } else {
            AABB boundingBox = entity.getBoundingBox();
            Vec3 velocity = new Vec3(entity.getX() - entity.xOld, entity.getY() - entity.yOld, entity.getZ() - entity.zOld);
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                Entity entity2 = this.shooter;
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)entity2;
                    int ping = Mth.floor((double)((double)serverPlayerOwner.connection.latency() / 1000.0 * 20.0 + 0.5));
                    boundingBox = HitboxHelper.getBoundingBox((Player)player, ping);
                    velocity = HitboxHelper.getVelocity((Player)player, ping);
                }
            }
            boundingBox = boundingBox.expandTowards(0.0, expandHeight, 0.0);
            boundingBox = boundingBox.expandTowards(velocity.x, velocity.y, velocity.z);
            double playerHitboxOffset = 3.0;
            if (entity instanceof ServerPlayer) {
                if (entity.getVehicle() != null) {
                    boundingBox = boundingBox.move(velocity.multiply(playerHitboxOffset / 2.0, playerHitboxOffset / 2.0, playerHitboxOffset / 2.0));
                }
                boundingBox = boundingBox.move(velocity.multiply(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
            }
            if (entity.getVehicle() != null) {
                boundingBox = boundingBox.move(velocity.multiply(-2.5, -2.5, -2.5));
            }
            boundingBox = boundingBox.move(velocity.multiply(-5.0, -5.0, -5.0));
            if (this.beast) {
                boundingBox = boundingBox.inflate(3.0);
            }
            hitPos = boundingBox.clip(startVec, endVec).orElse(null);
        }
        if (hitPos == null) {
            return null;
        }
        Vec3 hitBoxPos = hitPos.subtract(entity.position());
        boolean headshot = false;
        boolean legShot = false;
        float eyeHeight = entity.getEyeHeight();
        float bodyHeight = entity.getBbHeight();
        if ((double)eyeHeight - 0.25 < hitBoxPos.y && hitBoxPos.y < (double)eyeHeight + 0.3 && entity instanceof LivingEntity) {
            headshot = true;
        }
        if (hitBoxPos.y < 0.33 * (double)bodyHeight && entity instanceof LivingEntity) {
            legShot = true;
        }
        if (this.explosionDamage > 0.0f) {
            this.explosionBullet((Entity)this, hitPos);
        }
        return new EntityResult(entity, hitPos, headshot, legShot);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        builder.define(COLOR_R, (Object)Float.valueOf(1.0f)).define(COLOR_G, (Object)Float.valueOf(0.87058824f)).define(COLOR_B, (Object)Float.valueOf(0.15294118f));
    }

    public void tick() {
        Level randomPos2;
        ServerLevel serverLevel;
        Vec3 endVec;
        super.tick();
        this.updateHeading();
        Vec3 vec = this.getDeltaMovement();
        if (!this.level().isClientSide()) {
            Vec3 startVec = this.position();
            endVec = startVec.add(this.getDeltaMovement());
            Object result = ProjectileEntity.rayTraceBlocks(this.level(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), this.penetrating || this.beast ? state -> true : ((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get() != false ? IGNORE_LIST.and(input -> !input.is(ModTags.Blocks.BULLET_CAN_DESTROY)) : IGNORE_LIST));
            BlockHitResult fluidResult = ProjectileEntity.rayTraceBlocks(this.level(), new ClipContext(startVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this), this.penetrating || this.beast ? state -> true : ((Boolean)ProjectileConfig.ALLOW_PROJECTILE_DESTROY_BLOCKS.get() != false ? IGNORE_LIST.and(input -> !input.is(ModTags.Blocks.BULLET_CAN_DESTROY)) : IGNORE_LIST));
            if (result.getType() != HitResult.Type.MISS) {
                endVec = result.getLocation();
            }
            ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>();
            List<EntityResult> temp = this.findEntitiesOnPath(startVec, endVec);
            if (temp != null) {
                entityResults.addAll(temp);
            }
            if (this.shooter != null) {
                entityResults.sort(Comparator.comparingDouble(e -> e.getHitPos().distanceTo(this.shooter.position())));
            }
            for (EntityResult entityResult : entityResults) {
                DPSGeneratorEntity dpsGeneratorEntity;
                TargetEntity target;
                Entity entity;
                result = new ExtendedEntityRayTraceResult(entityResult);
                Entity entity2 = ((EntityHitResult)result).getEntity();
                if (entity2 instanceof Player) {
                    Player p;
                    Player player = (Player)entity2;
                    entity = this.shooter;
                    if (entity instanceof Player && !(p = (Player)entity).canHarmPlayer(player)) {
                        result = null;
                    }
                }
                if (result != null) {
                    this.onHit((HitResult)result);
                }
                if (this.beast) continue;
                this.bypassArmorRate -= 0.2f;
                if (!(this.bypassArmorRate < 0.8f) || result == null || (entity = ((EntityHitResult)result).getEntity()) instanceof TargetEntity && (Integer)(target = (TargetEntity)entity).getEntityData().get(TargetEntity.DOWN_TIME) > 0 || (entity = ((EntityHitResult)result).getEntity()) instanceof DPSGeneratorEntity && (Integer)(dpsGeneratorEntity = (DPSGeneratorEntity)entity).getEntityData().get(DPSGeneratorEntity.DOWN_TIME) > 0) continue;
                break;
            }
            if (entityResults.isEmpty()) {
                this.onHit((HitResult)result);
            }
            this.onHitWater(fluidResult.getLocation(), fluidResult);
            this.setPos(this.getX() + vec.x, this.getY() + vec.y, this.getZ() + vec.z);
        } else {
            this.setPosRaw(this.getX() + vec.x, this.getY() + vec.y, this.getZ() + vec.z);
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)(-this.gravity), 0.0));
        if (this.tickCount > (this.fireLevel > 0 ? 10 : 40)) {
            this.discard();
        }
        if (this.fireLevel > 0 && this.dragonBreath && (endVec = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)endVec;
            double randomPos2 = (double)this.tickCount * 0.08 * (Math.random() - 0.5);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.FLAME, (this.xo + this.getX()) / 2.0 + randomPos2, (this.yo + this.getY()) / 2.0 + randomPos2, (this.zo + this.getZ()) / 2.0 + randomPos2, 0, this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, Math.max(this.getDeltaMovement().length() - 1.1 * (double)this.tickCount, 0.2), true);
        }
        if ((randomPos2 = this.level()) instanceof ServerLevel) {
            serverLevel = (ServerLevel)randomPos2;
            if (VectorTool.isInLiquid((Level)serverLevel, this.position())) {
                this.setDeltaMovement(this.getDeltaMovement().multiply(0.75, 0.75, 0.75));
            }
            if (this.isInWater()) {
                double l = this.getDeltaMovement().length();
                for (double i = 0.0; i < l; i += 1.0) {
                    Vec3 startPos = new Vec3(this.xo, this.yo, this.zo);
                    Vec3 pos = startPos.add(this.getDeltaMovement().normalize().scale(i));
                    ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, pos.x, pos.y, pos.z, 1, 0.0, 0.0, 0.0, 0.001, true);
                }
            }
        }
        this.syncMotion();
    }

    @Override
    public void syncMotion() {
        if (!this.level().isClientSide) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new ClientMotionSyncMessage((Entity)this), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void onHit(@Nullable HitResult result) {
        if (result instanceof BlockHitResult) {
            Level level;
            BlockHitResult blockHitResult = (BlockHitResult)result;
            if (blockHitResult.getType() == HitResult.Type.MISS) {
                return;
            }
            BlockPos resultPos = blockHitResult.getBlockPos();
            BlockState state = this.level().getBlockState(resultPos);
            SoundEvent event = state.getBlock().getSoundType(state, (LevelReader)this.level(), resultPos, (Entity)this).getBreakSound();
            this.level().playSound(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, event, SoundSource.AMBIENT, 1.0f, 1.0f);
            Vec3 hitVec = result.getLocation();
            this.onHitBlock(hitVec, blockHitResult);
            if (this.explosionDamage > 0.0f) {
                this.explosionBullet((Entity)this, hitVec);
            }
            if (this.fireLevel > 0 && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, hitVec.x, hitVec.y, hitVec.z, 3, 0.0, 0.0, 0.0, 0.5, true);
            }
        }
        if (result instanceof ExtendedEntityRayTraceResult) {
            Player player;
            ExtendedEntityRayTraceResult entityHitResult = (ExtendedEntityRayTraceResult)result;
            Entity entity = entityHitResult.getEntity();
            if (entity.getId() == this.shooterId) {
                return;
            }
            Entity entity2 = this.shooter;
            if (entity2 instanceof Player && entity.hasIndirectPassenger((Entity)(player = (Player)entity2))) {
                return;
            }
            this.onHitEntity(entity, entityHitResult);
            entity.invulnerableTime = 0;
        }
    }

    private int getRings(@NotNull Direction direction, @NotNull Vec3 hitVec) {
        double x = Math.abs(Mth.frac((double)hitVec.x) - 0.5);
        double y = Math.abs(Mth.frac((double)hitVec.y) - 0.5);
        double z = Math.abs(Mth.frac((double)hitVec.z) - 0.5);
        Direction.Axis axis = direction.getAxis();
        double v = axis == Direction.Axis.Y ? Math.max(x, z) : (axis == Direction.Axis.Z ? Math.max(x, y) : Math.max(y, z));
        return Math.max(1, Mth.ceil((double)(10.0 * Mth.clamp((double)((0.5 - v) / 0.5), (double)0.0, (double)1.0))));
    }

    public void recordHitScore(@NotNull Direction direction, @NotNull Vec3 hitVec) {
        ItemStack stack;
        Entity entity;
        if (this.shooter == null) {
            return;
        }
        int score = this.getRings(direction, hitVec);
        double distance = this.shooter.position().distanceTo(hitVec);
        Entity entity2 = this.shooter;
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player player = (Player)entity2;
        player.displayClientMessage((Component)Component.literal((String)String.valueOf(score)).append((Component)Component.translatable((String)"tips.superbwarfare.shoot.rings")).append((Component)Component.literal((String)(" " + FormatTool.format1D(distance, "m")))), false);
        if (!this.level().isClientSide() && (entity = this.shooter) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Holder holder = score == 10 ? Holder.direct((Object)((SoundEvent)ModSounds.HEADSHOT.get())) : Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
            serverPlayer.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ClientIndicatorMessage(score == 10 ? 1 : 0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        if ((stack = player.getOffhandItem()).is((Item)ModItems.TRANSCRIPT.get())) {
            int size = 10;
            List scores = (List)stack.get(ModDataComponents.TRANSCRIPT_SCORE);
            if (scores == null) {
                scores = List.of();
            }
            ArrayDeque<Pair> queue = new ArrayDeque<Pair>(scores);
            queue.offer(new Pair((Object)score, (Object)distance));
            while (queue.size() > 10) {
                queue.poll();
            }
            stack.set(ModDataComponents.TRANSCRIPT_SCORE, List.copyOf(queue));
        }
    }

    protected void onHitWater(Vec3 location, BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.getBlockPos();
            Direction face = result.getDirection();
            BlockState state = this.level().getBlockState(pos);
            double vx = face.getStepX();
            double vy = face.getStepY();
            double vz = face.getStepZ();
            Vec3 dir = new Vec3(vx, vy, vz).add(this.getDeltaMovement().normalize().scale(-0.1));
            if (state.getBlock() == Blocks.WATER) {
                if (!this.isInWater()) {
                    CustomCloudOption particleData = new CustomCloudOption(1.0f, 1.0f, 1.0f, 80, 0.5f, 1.0f, false, false);
                    for (int i = 0; i < 10; ++i) {
                        Vec3 vec3 = this.randomVec(dir, 40.0);
                        ParticleTool.sendParticle(serverLevel, particleData, location.x + 0.12 * (double)i * dir.x, location.y + 0.12 * (double)i * dir.y, location.z + 0.12 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 15.0, true);
                    }
                    ParticleTool.spawnBulletHitWaterParticles((Level)serverLevel, location);
                    serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), (SoundEvent)ModSounds.HIT_WATER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    double l = this.getDeltaMovement().length();
                    for (double i = 0.0; i < l; i += 1.0) {
                        Vec3 p = location.add(this.getDeltaMovement().normalize().scale(i));
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, p.x, p.y, p.z, 1, 0.0, 0.0, 0.0, 0.001, false);
                    }
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.1, 0.1, 0.1));
                }
            } else if (state.getBlock() == Blocks.LAVA && !this.isInLava()) {
                BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, state);
                for (int i = 0; i < 7; ++i) {
                    Vec3 vec3 = this.randomVec(dir, 20.0);
                    ParticleTool.sendParticle(serverLevel, particleData, location.x + 0.1 * (double)i * dir.x, location.y + 0.1 * (double)i * dir.y, location.z + 0.1 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 10.0, true);
                }
                ParticleTool.sendParticle(serverLevel, ParticleTypes.LAVA, location.x, location.y, location.z, 4, 0.0, 0.0, 0.0, 0.6, true);
                serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), SoundEvents.LAVA_POP, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.discard();
            }
        }
    }

    protected void onHitBlock(Vec3 location, BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pos = result.getBlockPos();
            Direction face = result.getDirection();
            BlockState state = this.level().getBlockState(pos);
            if (((ProjectileHitEvent.HitBlock)NeoForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitBlock(pos, state, face, this.shooter, this, result.getLocation()))).isCanceled()) {
                return;
            }
            double vx = face.getStepX();
            double vy = face.getStepY();
            double vz = face.getStepZ();
            Vec3 dir = new Vec3(vx, vy, vz);
            if (this.beast) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.END_ROD, location.x, location.y, location.z, 15, 0.1, 0.1, 0.1, 0.05, true);
            } else {
                BulletDecalOption bulletDecalOption = ((Float)this.entityData.get(COLOR_R)).floatValue() == 1.0f && ((Float)this.entityData.get(COLOR_G)).floatValue() == 0.87058824f && ((Float)this.entityData.get(COLOR_B)).floatValue() == 0.15294118f ? new BulletDecalOption(result.getDirection(), result.getBlockPos()) : new BulletDecalOption(result.getDirection(), result.getBlockPos(), ((Float)this.entityData.get(COLOR_R)).floatValue(), ((Float)this.entityData.get(COLOR_G)).floatValue(), ((Float)this.entityData.get(COLOR_B)).floatValue());
                ParticleTool.sendParticle(serverLevel, bulletDecalOption, location.x, location.y, location.z, 1, 0.0, 0.0, 0.0, 0.0, true);
                this.summonVectorParticle(serverLevel, state, location, dir);
                this.discard();
            }
            serverLevel.playSound(null, new BlockPos((int)location.x, (int)location.y, (int)location.z), (SoundEvent)ModSounds.LAND.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void summonVectorParticle(ServerLevel serverLevel, BlockState state, Vec3 pos, Vec3 dir) {
        Vec3 vec3;
        int i;
        BlockParticleOption particleData = new BlockParticleOption(ParticleTypes.BLOCK, state);
        for (i = 0; i < 7; ++i) {
            vec3 = this.randomVec(dir, 40.0);
            ParticleTool.sendParticle(serverLevel, particleData, pos.x + 0.05 * (double)i * dir.x, pos.y + 0.05 * (double)i * dir.y, pos.z + 0.05 * (double)i * dir.z, 0, vec3.x, vec3.y, vec3.z, 10.0, true);
        }
        for (i = 0; i < 3; ++i) {
            vec3 = this.randomVec(dir, 20.0);
            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, pos.x, pos.y, pos.z, 0, vec3.x, vec3.y, vec3.z, 0.05, true);
        }
        BlockPos blockPos = BlockPos.containing((Position)pos);
        if (state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.METAL || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.ANVIL || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.CHAIN || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.COPPER || state.getSoundType((LevelReader)serverLevel, blockPos, null) == SoundType.NETHERITE_BLOCK) {
            serverLevel.playSound(null, pos.x, pos.y, pos.z, (SoundEvent)ModSounds.HIT.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            for (int i2 = 0; i2 < 3; ++i2) {
                Vec3 vec32 = this.randomVec(dir, 80.0);
                ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), pos.x, pos.y, pos.z, 0, vec32.x, vec32.y, vec32.z, 0.2 + 0.1 * Math.random(), true);
            }
        }
    }

    public Vec3 randomVec(Vec3 vec3, double spread) {
        return vec3.normalize().add(this.random.triangle(0.0, 0.0172275 * spread), this.random.triangle(0.0, 0.0172275 * spread), this.random.triangle(0.0, 0.0172275 * spread));
    }

    protected void onHitEntity(Entity entity, ExtendedEntityRayTraceResult result) {
        LivingEntity living;
        if (entity == null) {
            return;
        }
        boolean headshot = result.isHeadshot();
        boolean legShot = result.isLegShot();
        if (((ProjectileHitEvent.HitEntity)NeoForge.EVENT_BUS.post((Event)new ProjectileHitEvent.HitEntity(this.shooter, (Projectile)this, result))).isCanceled()) {
            return;
        }
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity = part.getParent();
        }
        if (entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.level().playSound(null, living.getOnPos(), (SoundEvent)ModSounds.MELEE_HIT.get(), SoundSource.PLAYERS, 1.0f, (float)(2.0 * Math.random() - 1.0) * 0.1f + 1.0f);
            if (this.beast) {
                Beast.beastKill(this.shooter, (Entity)living);
                return;
            }
        }
        this.damage *= (float)Mth.clamp((double)(this.getDeltaMovement().length() / (double)this.velocity), (double)0.0, (double)1.0);
        if (headshot) {
            Object object;
            if (!this.level().isClientSide() && (object = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)object;
                holder = Holder.direct((Object)((SoundEvent)ModSounds.HEADSHOT.get()));
                player.connection.send((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(1, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            this.performOnHit(entity, this.damage, true, this.knockback);
        } else {
            if (!this.level().isClientSide() && (holder = this.shooter) instanceof ServerPlayer) {
                player = (ServerPlayer)holder;
                holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
                player.connection.send((Packet)new ClientboundSoundPacket((Holder)holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (legShot) {
                if (entity instanceof LivingEntity) {
                    Player player;
                    living = (LivingEntity)entity;
                    if (living instanceof Player && (player = (Player)living).isCreative()) {
                        return;
                    }
                    if (!living.level().isClientSide()) {
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 2, false, false));
                    }
                }
                this.damage *= this.legShot;
            }
            this.performOnHit(entity, this.damage, false, this.knockback);
        }
        if (!this.mobEffects.isEmpty() && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            for (MobEffectInstance instance : this.mobEffects) {
                living.addEffect(instance, this.shooter);
            }
        }
        this.discard();
    }

    public void performOnHit(Entity entity, float damage, boolean headshot, double knockback) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.forceKnockback) {
                Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
                living.addDeltaMovement(vec3.scale(knockback));
                this.performDamage(entity, damage, headshot);
            } else {
                ICustomKnockback iCustomKnockback = ICustomKnockback.getInstance(living);
                iCustomKnockback.superbWarfare$setKnockbackStrength(knockback);
                this.performDamage(entity, damage, headshot);
                iCustomKnockback.superbWarfare$resetKnockbackStrength();
            }
        } else {
            this.performDamage(entity, damage, headshot);
        }
    }

    protected void explosionBullet(Entity projectile, Vec3 hitVec) {
        new CustomExplosion.Builder(projectile).attacker(this.getShooter()).damage(this.explosionDamage).radius(this.explosionRadius).position(hitVec).explode();
    }

    @Override
    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public void shoot(LivingEntity living, double vecX, double vecY, double vecZ, float velocity, float spread) {
        Vec3 vec3 = new Vec3(vecX, vecY, vecZ).normalize().add(this.random.triangle(0.0, 0.0172275 * (double)spread), this.random.triangle(0.0, 0.0172275 * (double)spread), this.random.triangle(0.0, 0.0172275 * (double)spread)).scale((double)velocity);
        this.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    public static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return ProjectileEntity.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.getBlockState(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.getFluidState(blockPos);
            Vec3 startVec = rayTraceContext.getFrom();
            Vec3 endVec = rayTraceContext.getTo();
            VoxelShape blockShape = rayTraceContext.getBlockShape(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.clipWithInteractionOverride(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.getFluidShape(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.clip(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(blockResult.getLocation());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.getFrom().distanceToSqr(fluidResult.getLocation());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d2 = rayTraceContext.getFrom().subtract(rayTraceContext.getTo());
            return BlockHitResult.miss((Vec3)rayTraceContext.getTo(), (Direction)Direction.getNearest((double)Vector3d2.x, (double)Vector3d2.y, (double)Vector3d2.z), (BlockPos)BlockPos.containing((Position)rayTraceContext.getTo()));
        });
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        Vec3 endVec;
        Vec3 startVec = context.getFrom();
        if (!startVec.equals((Object)(endVec = context.getTo()))) {
            int blockZ;
            int blockY;
            double startX = Mth.lerp((double)-1.0E-7, (double)endVec.x, (double)startVec.x);
            double startY = Mth.lerp((double)-1.0E-7, (double)endVec.y, (double)startVec.y);
            double startZ = Mth.lerp((double)-1.0E-7, (double)endVec.z, (double)startVec.z);
            double endX = Mth.lerp((double)-1.0E-7, (double)startVec.x, (double)endVec.x);
            double endY = Mth.lerp((double)-1.0E-7, (double)startVec.y, (double)endVec.y);
            double endZ = Mth.lerp((double)-1.0E-7, (double)startVec.z, (double)endVec.z);
            int blockX = Mth.floor((double)endX);
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.floor((double)endY), blockZ = Mth.floor((double)endZ));
            T t = hitFunction.apply(context, (BlockPos)mutablePos);
            if (t != null) {
                return t;
            }
            double deltaX = startX - endX;
            double deltaY = startY - endY;
            double deltaZ = startZ - endZ;
            int signX = Mth.sign((double)deltaX);
            int signY = Mth.sign((double)deltaY);
            int signZ = Mth.sign((double)deltaZ);
            double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
            double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
            double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
            double d12 = d9 * (signX > 0 ? 1.0 - Mth.frac((double)endX) : Mth.frac((double)endX));
            double d13 = d10 * (signY > 0 ? 1.0 - Mth.frac((double)endY) : Mth.frac((double)endY));
            double d14 = d11 * (signZ > 0 ? 1.0 - Mth.frac((double)endZ) : Mth.frac((double)endZ));
            while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
                T t1;
                if (d12 < d13) {
                    if (d12 < d14) {
                        blockX += signX;
                        d12 += d9;
                    } else {
                        blockZ += signZ;
                        d14 += d11;
                    }
                } else if (d13 < d14) {
                    blockY += signY;
                    d13 += d10;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
                if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.set(blockX, blockY, blockZ))) == null) continue;
                return t1;
            }
        }
        return p_217300_2_.apply(context);
    }

    @Nullable
    public Entity getShooter() {
        return this.shooter;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    public float getBypassArmorRate() {
        return this.bypassArmorRate;
    }

    public void updateHeading() {
        double horizontalDistance = this.getDeltaMovement().horizontalDistance();
        this.setYRot((float)(Mth.atan2((double)this.getDeltaMovement().x(), (double)this.getDeltaMovement().z()) * 57.29577951308232));
        this.setXRot((float)(Mth.atan2((double)this.getDeltaMovement().y(), (double)horizontalDistance) * 57.29577951308232));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private void performDamage(Entity entity, float damage, boolean isHeadshot) {
        float headShotModifier;
        float rate = Mth.clamp((float)this.bypassArmorRate, (float)0.0f, (float)1.0f);
        float normalDamage = damage * Mth.clamp((float)(1.0f - rate), (float)0.0f, (float)1.0f);
        float absoluteDamage = damage * Mth.clamp((float)rate, (float)0.0f, (float)1.0f);
        entity.invulnerableTime = 0;
        float f = headShotModifier = isHeadshot ? this.headShot : 1.0f;
        if (absoluteDamage > 0.0f) {
            DamageHandler.doDamage(entity, isHeadshot ? ModDamageTypes.causeGunFireHeadshotAbsoluteDamage(this.level().registryAccess(), (Entity)this, this.shooter) : ModDamageTypes.causeGunFireAbsoluteDamage(this.level().registryAccess(), (Entity)this, this.shooter), absoluteDamage * headShotModifier);
            entity.invulnerableTime = 0;
            if (entity instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entity;
                if (this.bypassArmorRate > 1.0f) {
                    vehicle.hurt(ModDamageTypes.causeGunFireAbsoluteDamage(this.level().registryAccess(), (Entity)this, this.shooter), absoluteDamage * (this.bypassArmorRate - 1.0f) * 0.5f);
                }
            }
        }
        if (normalDamage > 0.0f) {
            entity.hurt(isHeadshot ? ModDamageTypes.causeGunFireHeadshotDamage(this.level().registryAccess(), (Entity)this, this.shooter) : ModDamageTypes.causeGunFireDamage(this.level().registryAccess(), (Entity)this, this.shooter), normalDamage * headShotModifier);
            entity.invulnerableTime = 0;
        }
    }

    @Override
    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public void setExplosionDamage(float explosionDamage) {
        this.explosionDamage = explosionDamage;
    }

    @Override
    public void setExplosionRadius(float radius) {
        this.explosionRadius = radius;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isZoom() {
        return this.zoom;
    }

    @Nullable
    public String getGunItemId() {
        return this.gunItemId;
    }

    public boolean isPenetrating() {
        return this.penetrating;
    }

    public void setPenetrating(boolean penetrating) {
        this.penetrating = penetrating;
    }

    public ProjectileEntity shooter(@Nullable Entity shooter) {
        this.shooter = shooter;
        return this;
    }

    public ProjectileEntity damage(float damage) {
        this.damage = damage;
        return this;
    }

    public ProjectileEntity velocity(float velocity) {
        this.velocity = velocity;
        return this;
    }

    public ProjectileEntity headShot(float headShot) {
        this.headShot = headShot;
        return this;
    }

    public ProjectileEntity legShot(float legShot) {
        this.legShot = legShot;
        return this;
    }

    public ProjectileEntity beast() {
        this.beast = true;
        return this;
    }

    public ProjectileEntity fireBullet(int fireLevel, boolean dragonBreath) {
        this.fireLevel = fireLevel;
        this.dragonBreath = dragonBreath;
        return this;
    }

    public ProjectileEntity zoom(boolean zoom) {
        this.zoom = zoom;
        return this;
    }

    public ProjectileEntity bypassArmorRate(float bypassArmorRate) {
        this.bypassArmorRate = bypassArmorRate;
        return this;
    }

    public ProjectileEntity effect(ArrayList<MobEffectInstance> mobEffectInstances) {
        this.mobEffects.addAll(mobEffectInstances);
        return this;
    }

    public void setRGB(float[] rgb) {
        this.entityData.set(COLOR_R, (Object)Float.valueOf(rgb[0]));
        this.entityData.set(COLOR_G, (Object)Float.valueOf(rgb[1]));
        this.entityData.set(COLOR_B, (Object)Float.valueOf(rgb[2]));
    }

    public ProjectileEntity knockback(float knockback) {
        this.knockback = knockback;
        return this;
    }

    public ProjectileEntity forceKnockback() {
        this.forceKnockback = true;
        return this;
    }

    public ProjectileEntity setGunItemId(ItemStack stack) {
        this.gunItemId = stack.getDescriptionId();
        return this;
    }

    public ProjectileEntity setGunItemId(String id) {
        this.gunItemId = id;
        return this;
    }
}

