/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.drone_attachment.DroneAttachmentData;
import com.atsuishio.superbwarfare.entity.projectile.C4Entity;
import com.atsuishio.superbwarfare.entity.projectile.LaserEntity;
import com.atsuishio.superbwarfare.entity.projectile.ProjectileEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientMouseHandler;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.Monitor;
import com.atsuishio.superbwarfare.tools.CameraTool;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.TagDataParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector3f;
import org.joml.Vector4d;

public class DroneEntity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Boolean> LINKED = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> CONTROLLER = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Boolean> IS_KAMIKAZE = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Float> DELTA_X_ROT = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<String> DISPLAY_ENTITY = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<CompoundTag> DISPLAY_ENTITY_TAG = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<List<Float>> DISPLAY_DATA = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.FLOAT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Integer> MAX_AMMO = SynchedEntityData.defineId(DroneEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public boolean fire;
    public int collisionCoolDown;
    public double lastTickSpeed;
    public double lastTickVerticalSpeed;
    public ItemStack currentItem = ItemStack.EMPTY;
    public float pitch;
    public float pitchO;
    public int holdTickX;
    public int holdTickY;
    public int holdTickZ;

    public DroneEntity(EntityType<DroneEntity> type, Level world) {
        super(type, world);
    }

    public float getBodyPitch() {
        return this.pitch;
    }

    public void setBodyXRot(float rot) {
        this.pitch = rot;
    }

    public float getBodyPitch(float tickDelta) {
        return Mth.lerp((float)(0.6f * tickDelta), (float)this.pitchO, (float)this.getBodyPitch());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        DroneAttachmentData data = new DroneAttachmentData();
        builder.define(DELTA_X_ROT, (Object)Float.valueOf(0.0f)).define(CONTROLLER, (Object)"undefined").define(LINKED, (Object)false).define(IS_KAMIKAZE, (Object)false).define(DISPLAY_ENTITY, (Object)"").define(DISPLAY_DATA, List.of(Float.valueOf(data.scale()[0]), Float.valueOf(data.scale()[1]), Float.valueOf(data.scale()[2]), Float.valueOf(data.offset()[0]), Float.valueOf(data.offset()[1]), Float.valueOf(data.offset()[2]), Float.valueOf(data.rotation()[0]), Float.valueOf(data.rotation()[1]), Float.valueOf(data.rotation()[2]), Float.valueOf(data.xLength), Float.valueOf(data.zLength), Float.valueOf(data.tickCount))).define(DISPLAY_ENTITY_TAG, (Object)new CompoundTag()).define(MAX_AMMO, (Object)1);
    }

    public boolean causeFallDamage(float l, float d, @NotNull DamageSource source) {
        return false;
    }

    @Override
    public boolean shouldSendHitSounds() {
        return false;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Linked", ((Boolean)this.entityData.get(LINKED)).booleanValue());
        compound.putString("Controller", (String)this.entityData.get(CONTROLLER));
        compound.putInt("Ammo", ((Integer)this.entityData.get(AMMO)).intValue());
        compound.putBoolean("KamikazeMode", ((Boolean)this.entityData.get(IS_KAMIKAZE)).booleanValue());
        compound.putInt("MaxAmmo", ((Integer)this.entityData.get(MAX_AMMO)).intValue());
        compound.putString("DisplayEntity", (String)this.entityData.get(DISPLAY_ENTITY));
        compound.putString("DisplayEntityTag", ((CompoundTag)this.entityData.get(DISPLAY_ENTITY_TAG)).toString());
        compound.putString("DisplayData", ((List)this.entityData.get(DISPLAY_DATA)).stream().map(Object::toString).collect(Collectors.joining(",")));
        CompoundTag item = new CompoundTag();
        if (!item.isEmpty()) {
            this.currentItem.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)item);
        }
        compound.put("Item", (Tag)item);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Linked")) {
            this.entityData.set(LINKED, (Object)compound.getBoolean("Linked"));
        }
        if (compound.contains("Controller")) {
            this.entityData.set(CONTROLLER, (Object)compound.getString("Controller"));
        }
        if (compound.contains("Ammo")) {
            this.entityData.set(AMMO, (Object)compound.getInt("Ammo"));
        }
        if (compound.contains("KamikazeMode")) {
            this.entityData.set(IS_KAMIKAZE, (Object)compound.getBoolean("KamikazeMode"));
        }
        if (compound.contains("Item")) {
            this.currentItem = ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound.getCompound("Item")).orElse(ItemStack.EMPTY);
        }
        if (compound.contains("MaxAmmo")) {
            this.entityData.set(MAX_AMMO, (Object)compound.getInt("MaxAmmo"));
        }
        if (compound.contains("DisplayEntity")) {
            this.entityData.set(DISPLAY_ENTITY, (Object)compound.getString("DisplayEntity"));
        }
        if (compound.contains("DisplayEntityTag")) {
            this.entityData.set(DISPLAY_ENTITY_TAG, (Object)compound.getCompound("DisplayEntityTag"));
        }
        if (compound.contains("DisplayData")) {
            this.entityData.set(DISPLAY_DATA, Arrays.stream(compound.getString("DisplayData").split(",")).map(Float::valueOf).collect(Collectors.toList()));
        }
    }

    @Override
    public int maxRepairCoolDown() {
        return -1;
    }

    @Override
    public void baseTick() {
        CompoundTag tag;
        ItemStack stack;
        this.pitchO = this.getBodyPitch();
        this.setBodyXRot(this.pitch * 0.9f);
        super.baseTick();
        this.setZRot(this.getRoll() * 0.9f);
        this.lastTickSpeed = this.getDeltaMovement().length();
        this.lastTickVerticalSpeed = this.getDeltaMovement().y;
        if (this.collisionCoolDown > 0) {
            --this.collisionCoolDown;
        }
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (!this.onGround() && controller != null) {
            stack = controller.getMainHandItem();
            tag = NBTTool.getTag(stack);
            if (!stack.is((Item)ModItems.MONITOR.get()) || !tag.getBoolean("Using")) {
                this.setLeftInputDown(false);
                this.setRightInputDown(false);
                this.setForwardInputDown(false);
                this.setBackInputDown(false);
                this.setUpInputDown(false);
                this.setDownInputDown(false);
            }
            if (this.tickCount % 5 == 0) {
                controller.getInventory().items.stream().filter(pStack -> pStack.getItem() == ModItems.MONITOR.get()).forEach(pStack -> {
                    if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                        Monitor.getDronePos(pStack, this.position());
                    }
                });
            }
        }
        if (this.isInWater()) {
            this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)controller), 0.25f + (float)(2.0 * this.lastTickSpeed));
        }
        if (this.fire && (Integer)this.entityData.get(AMMO) > 0) {
            if (!((Boolean)this.entityData.get(IS_KAMIKAZE)).booleanValue()) {
                this.entityData.set(AMMO, (Object)((Integer)this.entityData.get(AMMO) - 1));
                if (controller != null && this.level() instanceof ServerLevel) {
                    this.droneDrop(controller);
                }
            } else if (controller != null) {
                stack = controller.getMainHandItem();
                if (stack.is((Item)ModItems.MONITOR.get())) {
                    tag = NBTTool.getTag(stack);
                    Monitor.disLink(tag, controller);
                    NBTTool.saveTag(stack, tag);
                }
                this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)controller), 10000.0f);
            }
            this.fire = false;
        }
        this.refreshDimensions();
    }

    private void droneDrop(@Nullable Player player) {
        DroneAttachmentData data = CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
        if (data == null) {
            return;
        }
        Entity dropEntity = EntityType.byString((String)data.dropEntity()).map(type -> type.create(this.level())).orElse(null);
        if (dropEntity == null) {
            return;
        }
        if (player != null && dropEntity instanceof Projectile) {
            Projectile projectile = (Projectile)dropEntity;
            projectile.setOwner((Entity)player);
        }
        CompoundTag tag = TagDataParser.parse(data.dropData(), name -> {
            if (player == null) {
                return StringTag.valueOf((String)name);
            }
            UUID uuid = player.getUUID();
            return switch (name) {
                case "@sbw:owner" -> NbtUtils.createUUID((UUID)uuid);
                case "@sbw:owner_string_lower" -> StringTag.valueOf((String)uuid.toString().replace("-", "").toLowerCase(Locale.ROOT));
                case "@sbw:owner_string_upper" -> StringTag.valueOf((String)uuid.toString().replace("-", "").toUpperCase(Locale.ROOT));
                default -> StringTag.valueOf((String)name);
            };
        });
        dropEntity.load(tag);
        float[] dropPos = data.dropPosition();
        dropEntity.setPos(this.getX() + (double)dropPos[0], this.getY() + (double)dropPos[1], this.getZ() + (double)dropPos[2]);
        Vec3 vec3 = new Vec3(0.2 * this.getDeltaMovement().x, 0.2 * this.getDeltaMovement().y, 0.2 * this.getDeltaMovement().z);
        dropEntity.setDeltaMovement(vec3);
        double d0 = vec3.horizontalDistance();
        dropEntity.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        dropEntity.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
        dropEntity.yRotO = dropEntity.getYRot();
        dropEntity.xRotO = dropEntity.getXRot();
        this.level().addFreshEntity(dropEntity);
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == ModItems.MONITOR.get()) {
            CompoundTag tag = NBTTool.getTag(stack);
            if (!player.isCrouching()) {
                if (!((Boolean)this.entityData.get(LINKED)).booleanValue()) {
                    if (tag.getBoolean("Linked")) {
                        player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.already_linked").withStyle(ChatFormatting.RED), true);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    this.entityData.set(LINKED, (Object)true);
                    this.entityData.set(CONTROLLER, (Object)player.getStringUUID());
                    Monitor.link(tag, this.getStringUUID());
                    NBTTool.saveTag(stack, tag);
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.linked").withStyle(ChatFormatting.GREEN), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.drone.already_linked").withStyle(ChatFormatting.RED), true);
                }
            } else if (((Boolean)this.entityData.get(LINKED)).booleanValue()) {
                if (!tag.getBoolean("Linked")) {
                    player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.drone.already_linked").withStyle(ChatFormatting.RED), true);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                this.entityData.set(CONTROLLER, (Object)"none");
                this.entityData.set(LINKED, (Object)false);
                Monitor.disLink(tag, player);
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.monitor.unlinked").withStyle(ChatFormatting.RED), true);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        } else if (player.isCrouching()) {
            if (stack.isEmpty() || stack.is(ModTags.Items.TOOLS_CROWBAR)) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.DRONE.get()));
                for (int index0 = 0; index0 < (Integer)this.entityData.get(AMMO); ++index0) {
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentItem.copy());
                }
                player.getInventory().items.stream().filter(stack_ -> stack_.getItem() == ModItems.MONITOR.get()).forEach(itemStack -> {
                    CompoundTag tag = NBTTool.getTag(itemStack);
                    if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                        Monitor.disLink(tag, player);
                    }
                });
                if (!this.level().isClientSide()) {
                    this.discard();
                }
            }
        } else if (stack.isEmpty()) {
            int ammo = (Integer)this.entityData.get(AMMO);
            if (ammo > 0) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)this.currentItem.copy());
                this.entityData.set(AMMO, (Object)(ammo - 1));
                if (ammo == 1) {
                    this.entityData.set(DISPLAY_ENTITY, (Object)"");
                    this.entityData.set(MAX_AMMO, (Object)1);
                    this.entityData.set(IS_KAMIKAZE, (Object)false);
                    this.currentItem = ItemStack.EMPTY;
                }
            }
        } else {
            String itemID = DroneEntity.getItemId(stack);
            DroneAttachmentData attachmentData = CustomData.DRONE_ATTACHMENT.get(itemID);
            if (attachmentData != null && (Integer)this.entityData.get(AMMO) < attachmentData.count()) {
                if (((String)this.entityData.get(DISPLAY_ENTITY)).equals(attachmentData.displayEntity()) && ItemStack.matches((ItemStack)this.currentItem, (ItemStack)stack.copyWithCount(1))) {
                    this.entityData.set(AMMO, (Object)((Integer)this.entityData.get(AMMO) + 1));
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                } else if ((Integer)this.entityData.get(AMMO) == 0) {
                    this.currentItem = stack.copyWithCount(1);
                    this.entityData.set(DISPLAY_ENTITY, (Object)attachmentData.displayEntity());
                    this.entityData.set(AMMO, (Object)((Integer)this.entityData.get(AMMO) + 1));
                    this.entityData.set(IS_KAMIKAZE, (Object)attachmentData.isKamikaze);
                    this.entityData.set(MAX_AMMO, (Object)attachmentData.count());
                    if (!player.isCreative()) {
                        stack.shrink(1);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.BULLET_SUPPLY.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
                    }
                    float[] scale = attachmentData.scale();
                    float[] offset = attachmentData.offset();
                    float[] rotation = attachmentData.rotation();
                    if (attachmentData.displayData() != null) {
                        this.entityData.set(DISPLAY_ENTITY_TAG, (Object)TagDataParser.parse(attachmentData.displayData(), name -> {
                            UUID uuid = player.getUUID();
                            return switch (name) {
                                case "@sbw:owner" -> NbtUtils.createUUID((UUID)uuid);
                                case "@sbw:owner_string_lower" -> StringTag.valueOf((String)uuid.toString().replace("-", "").toLowerCase(Locale.ROOT));
                                case "@sbw:owner_string_upper" -> StringTag.valueOf((String)uuid.toString().replace("-", "").toUpperCase(Locale.ROOT));
                                default -> StringTag.valueOf((String)name);
                            };
                        }));
                    }
                    this.entityData.set(DISPLAY_DATA, List.of(Float.valueOf(scale[0]), Float.valueOf(scale[1]), Float.valueOf(scale[2]), Float.valueOf(offset[0]), Float.valueOf(offset[1]), Float.valueOf(offset[2]), Float.valueOf(rotation[0]), Float.valueOf(rotation[1]), Float.valueOf(rotation[2]), Float.valueOf(attachmentData.xLength), Float.valueOf(attachmentData.zLength), Float.valueOf(attachmentData.tickCount)));
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
    }

    @Override
    public void travel() {
        if (!this.onGround()) {
            if (this.rightInputDown()) {
                ++this.holdTickX;
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else if (this.leftInputDown()) {
                ++this.holdTickX;
                this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickX, (int)5)));
            } else {
                this.holdTickX = 0;
            }
            if (this.forwardInputDown()) {
                ++this.holdTickZ;
                this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() - 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else if (this.backInputDown()) {
                ++this.holdTickZ;
                this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() + 0.3f * (float)Math.min((int)this.holdTickZ, (int)5)));
            } else {
                this.holdTickZ = 0;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.965, 0.7, 0.965));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 1.0, 0.8));
            this.setZRot(this.roll * 0.7f);
            this.setXRot(this.getXRot() * 0.7f);
            this.setBodyXRot(this.getBodyPitch() * 0.7f);
        }
        if (this.isInWater() && this.tickCount % 4 == 0) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            this.hurt(ModDamageTypes.causeVehicleStrikeDamage(this.level().registryAccess(), this, this.getFirstPassenger() == null ? this : this.getFirstPassenger()), 26.0f + (float)(60.0 * ((this.lastTickSpeed - 0.4) * (this.lastTickSpeed - 0.4))));
        }
        boolean up = this.upInputDown();
        boolean down = this.downInputDown();
        if (up) {
            ++this.holdTickY;
            this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.01f * (float)Math.min((int)this.holdTickY, (int)5)), (float)0.2f)));
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, 0.05 * (double)this.holdTickY, this.getDeltaMovement().z));
        } else if (down) {
            ++this.holdTickY;
            this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - 0.02f * (float)Math.min((int)this.holdTickY, (int)5)), (float)(this.onGround() ? 0.0f : 0.06f))));
            this.setDeltaMovement(new Vec3(this.getDeltaMovement().x, -0.05 * (double)this.holdTickY, this.getDeltaMovement().z));
        } else {
            this.holdTickY = 0;
        }
        if (!up && !down) {
            if (this.getDeltaMovement().y() < 0.0) {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.min((float)(((Float)this.entityData.get(POWER)).floatValue() + 0.005f), (float)0.2f)));
            } else {
                this.entityData.set(POWER, (Object)Float.valueOf(Math.max((float)(((Float)this.entityData.get(POWER)).floatValue() - (this.onGround() ? 5.0E-4f : 0.005f)), (float)0.02f)));
            }
        }
        this.entityData.set(DELTA_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_ROT)).floatValue() * 0.7f));
        this.entityData.set(DELTA_X_ROT, (Object)Float.valueOf(((Float)this.entityData.get(DELTA_X_ROT)).floatValue() * 0.7f));
        this.setZRot(Mth.clamp((float)(this.getRoll() - ((Float)this.entityData.get(DELTA_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.setBodyXRot(Mth.clamp((float)(this.getBodyPitch() - ((Float)this.entityData.get(DELTA_X_ROT)).floatValue()), (float)-30.0f, (float)30.0f));
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, (double)((Float)this.entityData.get(POWER)).floatValue() * 0.6, 0.0));
        Vector3f direction = this.getRightDirection().mul(((Float)this.entityData.get(DELTA_ROT)).floatValue());
        this.setDeltaMovement(this.getDeltaMovement().add(new Vec3((double)direction.x, (double)direction.y, (double)direction.z).scale(0.017)));
        Vector3f directionZ = this.getForwardDirection().mul(-((Float)this.entityData.get(DELTA_X_ROT)).floatValue());
        this.setDeltaMovement(this.getDeltaMovement().add(new Vec3((double)directionZ.x, (double)directionZ.y, (double)directionZ.z).scale(0.017)));
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null) {
            ItemStack stack = controller.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(stack);
            if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using")) {
                this.setYRot(this.getYRot() + 0.5f * this.getMouseMoveSpeedX());
                this.setXRot(Mth.clamp((float)(this.getXRot() + 0.5f * this.getMouseMoveSpeedY()), (float)-10.0f, (float)90.0f));
            }
        }
        float f = 0.7f;
        AABB aabb = AABB.ofSize((Vec3)this.getEyePosition(), (double)f, (double)0.3, (double)f);
        Level level = this.level();
        for (Entity target : level.getEntitiesOfClass(Entity.class, aabb, e -> true)) {
            if (this == target || target == null || target instanceof ItemEntity || target instanceof Projectile || target instanceof ProjectileEntity || target instanceof LaserEntity || target.getType().is(ModTags.EntityTypes.DECOY) || target instanceof AreaEffectCloud || target instanceof C4Entity) continue;
            this.hitEntityCrash(controller, target);
        }
    }

    public void hitEntityCrash(Player player, Entity target) {
        if (this.lastTickSpeed > 0.05) {
            String attachedEntity = (String)this.entityData.get(DISPLAY_ENTITY);
            if (!attachedEntity.isEmpty() && 50.0 * this.lastTickSpeed > (double)this.getHealth()) {
                DroneAttachmentData data = CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
                if (data != null) {
                    if (data.isKamikaze) {
                        EntityType.byString((String)attachedEntity).ifPresent(entityType -> {
                            Entity bomb = entityType.create(this.level());
                            DamageHandler.doDamage(target, ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), bomb, (Entity)player), data.hitDamage);
                            target.invulnerableTime = 0;
                        });
                    } else {
                        DamageHandler.doDamage(target, ModDamageTypes.causeDroneHitDamage(this.level().registryAccess(), this, (Entity)player), (float)(5.0 * this.lastTickSpeed));
                    }
                }
                if (player != null && player.getMainHandItem().is((Item)ModItems.MONITOR.get())) {
                    ItemStack stack = player.getMainHandItem();
                    CompoundTag tag = NBTTool.getTag(stack);
                    Monitor.disLink(tag, player);
                    NBTTool.saveTag(stack, tag);
                }
            }
            this.hurt(new DamageSource((Holder)this.level().registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(DamageTypes.EXPLOSION), (Entity)Objects.requireNonNullElse(player, this)), (float)((double)(!((String)this.entityData.get(DISPLAY_ENTITY)).isEmpty() ? 50 : 4) * this.lastTickSpeed));
        }
    }

    @Override
    public boolean engineRunning() {
        return (double)Math.abs((float)((Float)this.entityData.get(POWER)).floatValue()) > 0.05;
    }

    @Override
    public float getEngineSoundVolume() {
        if ((double)Math.abs((float)((Float)this.entityData.get(POWER)).floatValue()) <= 0.05) {
            return 0.0f;
        }
        Player player = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (player == null) {
            return ((Float)this.entityData.get(POWER)).floatValue();
        }
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)ModItems.MONITOR.get()) && NBTTool.getTag(stack).getBoolean("Using") && NBTTool.getTag(stack).getBoolean("Linked")) {
            return ((Float)this.entityData.get(POWER)).floatValue() * 0.25f;
        }
        return ((Float)this.entityData.get(POWER)).floatValue() * 2.0f;
    }

    @Override
    public void move(@NotNull MoverType movementType, @NotNull Vec3 movement) {
        super.move(movementType, movement);
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (this.lastTickSpeed < 0.2 || this.collisionCoolDown > 0) {
            return;
        }
        if (this.verticalCollision && Mth.abs((float)((float)this.lastTickVerticalSpeed)) > 1.0f) {
            this.hurt(ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, controller == null ? this : controller), (float)(20.0 * ((double)(Mth.abs((float)((float)this.lastTickVerticalSpeed)) - 1.0f) * (this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
        if (this.horizontalCollision) {
            this.hurt(ModDamageTypes.causeCustomExplosionDamage(this.level().registryAccess(), this, controller == null ? this : controller), (float)(10.0 * ((this.lastTickSpeed - 0.2) * (this.lastTickSpeed - 0.2))));
            this.collisionCoolDown = 4;
        }
    }

    static String getItemId(ItemStack stack) {
        return stack.getItem().toString();
    }

    @Override
    @Nullable
    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)ModItems.DRONE.get());
    }

    @Override
    public void destroy() {
        UUID uuid;
        DroneAttachmentData data;
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null && controller.getMainHandItem().is((Item)ModItems.MONITOR.get())) {
            ItemStack item = controller.getMainHandItem();
            CompoundTag tag = NBTTool.getTag(item);
            Monitor.disLink(tag, controller);
            NBTTool.saveTag(item, tag);
        }
        if (this.level() instanceof ServerLevel) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 0.0f, Level.ExplosionInteraction.NONE);
        }
        if ((data = CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem))) != null) {
            if (data.isKamikaze) {
                this.kamikazeExplosion();
            } else if (this.level() instanceof ServerLevel) {
                int count = (Integer)this.entityData.get(AMMO);
                for (int i = 0; i < count; ++i) {
                    this.droneDrop(controller);
                }
            }
        }
        String id = (String)this.entityData.get(CONTROLLER);
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException ignored) {
            this.discard();
            return;
        }
        Player player = this.level().getPlayerByUUID(uuid);
        if (player != null) {
            player.getInventory().items.stream().filter(stack -> stack.getItem() == ModItems.MONITOR.get()).forEach(stack -> {
                CompoundTag tag = NBTTool.getTag(stack);
                if (tag.getString("LinkedDrone").equals(this.getStringUUID())) {
                    Monitor.disLink(tag, player);
                    NBTTool.saveTag(stack, tag);
                }
            });
        }
        super.destroy();
    }

    private void kamikazeExplosion() {
        Entity attacker = EntityFindUtil.findEntity(this.level(), (String)this.entityData.get(LAST_ATTACKER_UUID));
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        assert (controller != null);
        String attachedEntity = (String)this.entityData.get(DISPLAY_ENTITY);
        if (attachedEntity.isEmpty()) {
            return;
        }
        DroneAttachmentData data = CustomData.DRONE_ATTACHMENT.get(DroneEntity.getItemId(this.currentItem));
        if (data == null) {
            return;
        }
        Entity bomb = EntityType.byString((String)attachedEntity).map(entityType -> entityType.create(this.level())).orElse(null);
        if (bomb == null) {
            return;
        }
        float radius = data.explosionRadius;
        ParticleTool.ParticleType particleType = radius < 4.0f ? ParticleTool.ParticleType.SMALL : (radius >= 4.0f && radius < 10.0f ? ParticleTool.ParticleType.MEDIUM : (radius >= 10.0f && radius < 20.0f ? ParticleTool.ParticleType.HUGE : ParticleTool.ParticleType.GIANT));
        this.createCustomExplosion().source(bomb).attacker(attacker).damage(data.explosionDamage).radius(radius).withParticleType(particleType).explode();
    }

    private void createAreaCloud(PotionContents potion, Level level, int duration, float radius) {
        if (potion == null || potion.potion().map(p -> p.value() == Potions.WATER.value()).orElse(false).booleanValue()) {
            return;
        }
        AreaEffectCloud cloud = new AreaEffectCloud(level, this.getX() + 0.75 * this.getDeltaMovement().x, this.getY() + 0.5 * (double)this.getBbHeight() + 0.75 * this.getDeltaMovement().y, this.getZ() + 0.75 * this.getDeltaMovement().z);
        for (MobEffectInstance effect : (List)potion.potion().map(p -> ((Potion)p.value()).getEffects()).orElse(new ArrayList())) {
            cloud.addEffect(effect);
        }
        cloud.setDuration(duration);
        cloud.setRadius(radius);
        Player controller = EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
        if (controller != null) {
            cloud.setOwner((LivingEntity)controller);
        }
        level.addFreshEntity((Entity)cloud);
    }

    @Override
    public boolean canCrushEntities() {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public Vec2 getCameraRotation(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        return new Vec2((float)((double)this.getYaw(partialTicks) - ClientMouseHandler.freeCameraYaw), (float)((double)this.getPitch(partialTicks) + ClientMouseHandler.freeCameraPitch));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Vec3 getCameraPosition(float partialTicks, Player player, boolean zoom, boolean isFirstPerson) {
        Matrix4d transform = this.getClientVehicleTransform(partialTicks);
        Vector4d maxCameraPosition = this.transformPosition(transform, 0.0, 0.75, -2.0 - 0.2 * ClientMouseHandler.custom3pDistanceLerp);
        return CameraTool.getMaxZoom(transform, maxCameraPosition);
    }

    public Entity getController() {
        return EntityFindUtil.findPlayer(this.level(), (String)this.entityData.get(CONTROLLER));
    }

    @Override
    public boolean hasEnergyStorage() {
        return false;
    }
}

