/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.vehicle.DefaultVehicleData;
import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.DestroyInfo;
import com.atsuishio.superbwarfare.entity.projectile.MelonBombEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Vector4d;

public class Tom6Entity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Boolean> MELON = SynchedEntityData.defineId(Tom6Entity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public Tom6Entity(EntityType<Tom6Entity> type, Level world) {
        super(type, world);
    }

    @Override
    public DefaultVehicleData computeProperties(VehicleData vehicleData, DefaultVehicleData rawData) {
        if (((Boolean)this.entityData.get(MELON)).booleanValue()) {
            rawData.destroyInfo = new DestroyInfo(rawData.destroyInfo.crashPassengers, rawData.destroyInfo.explodePassengers, rawData.destroyInfo.explodeBlocks, this.getMelonExplosionDamage(), this.getMelonExplosionRadius(), ParticleTool.ParticleType.HUGE);
        }
        return (DefaultVehicleData)super.computeProperties((DefaultDataSupplier)vehicleData, (Object)rawData);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(MELON, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Melon", ((Boolean)this.entityData.get(MELON)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(MELON, (Object)compound.getBoolean("Melon"));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getMainHandItem().is(Items.MELON) && !((Boolean)this.entityData.get(MELON)).booleanValue()) {
            this.entityData.set(MELON, (Object)true);
            player.getMainHandItem().shrink(1);
            player.level().playSound(player, this.getOnPos(), SoundEvents.WOOD_PLACE, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        Entity passenger = this.getFirstPassenger();
        if (this.upInputDown() && !this.onGround() && ((Boolean)this.entityData.get(MELON)).booleanValue() && passenger instanceof Player) {
            Player player = (Player)passenger;
            this.entityData.set(MELON, (Object)false);
            Matrix4d transform = this.getVehicleTransform(1.0f);
            Vector4d worldPosition = this.transformPosition(transform, 0.0, 0.3, 0.0);
            MelonBombEntity melonBomb = new MelonBombEntity((LivingEntity)player, player.level());
            melonBomb.setExplosionDamage(this.getMelonExplosionDamage());
            melonBomb.setExplosionRadius(this.getMelonExplosionRadius());
            melonBomb.setPos(worldPosition.x, worldPosition.y, worldPosition.z);
            melonBomb.shoot(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z, (float)this.getDeltaMovement().length(), 0.0f);
            passenger.level().addFreshEntity((Entity)melonBomb);
            this.level().playSound(null, this.getOnPos(), SoundEvents.IRON_DOOR_OPEN, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.setUpInputDown(false);
        }
    }

    public float getMelonExplosionDamage() {
        GunData gunData = this.getGunData("MelonBomb");
        if (gunData != null) {
            return (float)gunData.compute().explosionDamage;
        }
        return 0.0f;
    }

    public float getMelonExplosionRadius() {
        GunData gunData = this.getGunData("MelonBomb");
        if (gunData != null) {
            return (float)gunData.compute().explosionRadius;
        }
        return 0.0f;
    }

    @Override
    public boolean engineRunning() {
        return this.getFirstPassenger() != null && Math.abs((double)this.getDeltaMovement().length()) > 0.0;
    }

    @Override
    public float getEngineSoundVolume() {
        return (float)this.getDeltaMovement().length();
    }

    @Override
    public double getSensitivity(double original, boolean zoom, int seatIndex, boolean isOnGround) {
        return ModKeyMappings.FREE_CAMERA.isDown() ? 0.0 : 0.6;
    }

    @Override
    public boolean useAircraftCamera(int seatIndex) {
        return ModKeyMappings.FREE_CAMERA.isDown() && !ClientEventHandler.zoom;
    }

    @Override
    public double getMouseSensitivity() {
        return ModKeyMappings.FREE_CAMERA.isDown() ? 0.3 : 0.0;
    }
}

