/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class TowEntity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Boolean> LOADED = SynchedEntityData.defineId(TowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Integer> RELOAD_COOLDOWN = SynchedEntityData.defineId(TowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public TowEntity(EntityType<TowEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LOADED, (Object)false).define(RELOAD_COOLDOWN, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("State", ((Boolean)this.entityData.get(LOADED)).booleanValue());
        compound.putInt("ReloadCoolDown", ((Integer)this.entityData.get(RELOAD_COOLDOWN)).intValue());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(LOADED, (Object)compound.getBoolean("State"));
        this.entityData.set(RELOAD_COOLDOWN, (Object)compound.getInt("ReloadCoolDown"));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        GunData gunData = this.getGunData(0);
        if (gunData == null) {
            return InteractionResult.SUCCESS;
        }
        int coolDown = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(0) / 60.0f)));
        ItemStack stack = player.getMainHandItem();
        if (gunData.hasEnoughAmmoToShoot((Entity)player)) {
            this.entityData.set(LOADED, (Object)true);
            return super.interact(player, hand);
        }
        if (((Boolean)this.entityData.get(LOADED)).booleanValue()) {
            this.entityData.set(LOADED, (Object)false);
            return InteractionResult.SUCCESS;
        }
        if (!gunData.selectedAmmoConsumer().isAmmoItem(stack)) {
            return super.interact(player, hand);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if ((Integer)this.entityData.get(RELOAD_COOLDOWN) == 0) {
                this.modifyGunData(0, (GunData data) -> data.reloadAmmo((Entity)player));
                this.entityData.set(LOADED, (Object)true);
                serverLevel.playSound(null, this.getOnPos(), (SoundEvent)ModSounds.TYPE_63_RELOAD.get(), SoundSource.PLAYERS, 1.0f, this.random.nextFloat() * 0.1f + 0.9f);
                return InteractionResult.SUCCESS;
            }
        }
        player.displayClientMessage((Component)Component.literal((String)(FormatTool.format1DZ((double)(coolDown - (Integer)this.entityData.get(RELOAD_COOLDOWN)) / 20.0) + " / " + FormatTool.format1DZ((double)coolDown / 20.0))), true);
        return InteractionResult.SUCCESS;
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if ((Integer)this.entityData.get(RELOAD_COOLDOWN) > 0) {
            this.entityData.set(RELOAD_COOLDOWN, (Object)((Integer)this.entityData.get(RELOAD_COOLDOWN) - 1));
        }
    }

    @Override
    @NotNull
    public List<ItemStack> getRetrieveItems() {
        ItemStack stack;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)ModItems.TOW_DEPLOYER.get()));
        GunData data = this.getGunData(0);
        if (((Boolean)this.entityData.get(LOADED)).booleanValue() && data != null && !(stack = data.selectedAmmoConsumer().stack().copyWithCount(data.withdrawAmmoCount())).isEmpty()) {
            list.add(stack.copy());
        }
        return list;
    }

    @Override
    public void vehicleShoot(LivingEntity living, UUID uuid, Vec3 targetPos) {
        super.vehicleShoot(living, uuid, targetPos);
        Vec3 barrelVector = this.getBarrelVector(1.0f);
        Vec3 pos = this.getShootPos((Entity)living, 1.0f).add(barrelVector.scale(-0.5));
        AABB ab = new AABB(pos, pos).inflate(0.75).move(barrelVector.scale(-2.0)).expandTowards(barrelVector.scale(-5.0));
        int coolDown = (int)Math.ceil((float)(20.0f / ((float)this.vehicleWeaponRpm(0) / 60.0f)));
        this.entityData.set(RELOAD_COOLDOWN, (Object)coolDown);
        for (Entity entity : this.level().getEntities(EntityTypeTest.forClass(Entity.class), ab, target -> target != this && target != this.getFirstPassenger() && target.getVehicle() == null)) {
            entity.hurt(ModDamageTypes.causeBurnDamage(entity.level().registryAccess(), (Entity)living), 30.0f - 2.0f * entity.distanceTo((Entity)this));
            double force = 4.0 - 0.7 * (double)entity.distanceTo((Entity)this);
            entity.push(-force * barrelVector.x, -force * barrelVector.y, -force * barrelVector.z);
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector.scale(-1.0), pos, serverLevel, this);
            ParticleTool.spawnMediumCannonMuzzleParticles(barrelVector, pos, serverLevel, this);
        }
    }

    @Override
    public void destroy() {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            double x = this.getX();
            double y = this.getY();
            double z = this.getZ();
            level2.explode(null, x, y, z, 0.0f, Level.ExplosionInteraction.NONE);
            ItemEntity mortar = new ItemEntity((Level)level2, x, y + 1.0, z, new ItemStack((ItemLike)ModItems.MORTAR_BARREL.get()));
            mortar.setPickUpDelay(10);
            level2.addFreshEntity((Entity)mortar);
        }
        super.destroy();
    }
}

