/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class TruckEntity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<Boolean> GREEN = SynchedEntityData.defineId(TruckEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TruckEntity(EntityType<TruckEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GREEN, (Object)false);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Green", ((Boolean)this.entityData.get(GREEN)).booleanValue());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.entityData.set(GREEN, (Object)compound.getBoolean("Green"));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.getItem() == Items.LIME_DYE && !((Boolean)this.entityData.get(GREEN)).booleanValue()) {
            this.entityData.set(GREEN, (Object)true);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, SoundEvents.BONE_MEAL_USE, this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        if (stack.getItem() == Items.RED_DYE && ((Boolean)this.entityData.get(GREEN)).booleanValue()) {
            this.entityData.set(GREEN, (Object)false);
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            this.level().playSound(null, (Entity)this, SoundEvents.BONE_MEAL_USE, this.getSoundSource(), 2.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.interact(player, hand);
    }

    @Override
    public DamageModifier getDamageModifier() {
        return super.getDamageModifier().custom((source, damage) -> Float.valueOf(this.getSourceAngle((DamageSource)source, 0.25f) * damage.floatValue()));
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (this.decoyInputDown()) {
            this.horn();
        }
    }
}

