/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle;

import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.init.ModCriteriaTriggers;
import com.atsuishio.superbwarfare.init.ModItems;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class WheelChairEntity
extends GeoVehicleEntity {
    public WheelChairEntity(EntityType<WheelChairEntity> type, Level world) {
        super(type, world);
    }

    public void playerTouch(Player pPlayer) {
        if (this.position().distanceTo(pPlayer.position()) > 1.4 || pPlayer == this.getFirstPassenger() && pPlayer.position().y > this.position().y) {
            return;
        }
        if (!this.level().isClientSide && pPlayer.getY() < this.getY() + (double)this.getBbHeight() && pPlayer.getY() + (double)pPlayer.getBbHeight() > this.getY()) {
            double entitySize = pPlayer.getBbWidth() * pPlayer.getBbHeight();
            double thisSize = this.getBbWidth() * this.getBbHeight();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            this.setDeltaMovement(this.getDeltaMovement().add(new Vec3(pPlayer.position().vectorTo(this.position()).toVector3f()).scale(0.5 * f * pPlayer.getDeltaMovement().length())));
            this.setYRot(pPlayer.getYHeadRot());
        }
    }

    @Override
    public void baseTick() {
        super.baseTick();
        this.attractEntity();
    }

    public boolean hasEnoughSpaceFor(Entity pEntity) {
        return pEntity.getBbWidth() < this.getBbWidth();
    }

    public void attractEntity() {
        List list = this.level().getEntities((Entity)this, this.getBoundingBox().inflate((double)0.2f, (double)-0.01f, (double)0.2f));
        if (!list.isEmpty()) {
            boolean flag = !this.level().isClientSide && !(this.getControllingPassenger() instanceof Player);
            for (Entity entity : list) {
                if (entity.hasPassenger((Entity)this) || !flag || entity.isPassenger() || !this.hasEnoughSpaceFor(entity) || !(entity instanceof LivingEntity) && !(entity instanceof MortarEntity) || entity instanceof WaterAnimal || entity instanceof Player) continue;
                entity.startRiding((Entity)this);
            }
        }
    }

    @Override
    protected void addPassenger(@NotNull Entity pPassenger) {
        ServerPlayer player;
        super.addPassenger(pPassenger);
        if (pPassenger instanceof ServerPlayer && ((player = (ServerPlayer)pPassenger).getMainHandItem().getItem() == ModItems.ELECTRIC_BATON.get() || player.getOffhandItem().getItem() == ModItems.ELECTRIC_BATON.get())) {
            ModCriteriaTriggers.OTTO_SPRINT.get().trigger(player);
        }
    }
}

