/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.base;

import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.GeoVehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSerializers;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.FormatTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.RangeTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Vector3f;

public class ArtilleryEntity
extends GeoVehicleEntity {
    public static final EntityDataAccessor<List<Integer>> BARREL_ANIM = SynchedEntityData.defineId(ArtilleryEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModSerializers.INT_LIST_SERIALIZER.get()));
    public static final EntityDataAccessor<Vector3f> SHOOT_VEC = SynchedEntityData.defineId(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    public static final EntityDataAccessor<Boolean> DEPRESSED = SynchedEntityData.defineId(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<Vector3f> TARGET_POS = SynchedEntityData.defineId(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.VECTOR3);
    public static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(ArtilleryEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ArtilleryEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.entityData.set(BARREL_ANIM, ArtilleryEntity.newIntList(Math.max((int)4, (int)this.getMaxBarrel())));
    }

    @Override
    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        GunData gunData = this.getGunData("Main");
        if (gunData == null) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof ArtilleryIndicator) {
            ArtilleryIndicator indicator = (ArtilleryIndicator)item;
            return indicator.bind(stack, player, this);
        }
        if (stack.is(ModTags.Items.TOOLS_CROWBAR) && !player.isShiftKeyDown()) {
            if (gunData.ammo.get() > 0 && player.level() instanceof ServerLevel) {
                this.vehicleShoot((LivingEntity)player, "Main");
            }
            return InteractionResult.SUCCESS;
        }
        if (player.getMainHandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isShiftKeyDown()) {
            this.setTarget(player.getMainHandItem(), (Entity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        if (player.getOffhandItem().getItem() == ModItems.FIRING_PARAMETERS.get() && player.isShiftKeyDown()) {
            this.setTarget(player.getOffhandItem(), (Entity)player, "Main");
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.entityData.set(SHOOT_VEC, (Object)this.getForward().toVector3f());
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT_VEC, (Object)this.getForward().toVector3f()).define(DEPRESSED, (Object)false).define(TARGET_POS, (Object)new Vector3f()).define(RADIUS, (Object)0).define(BARREL_ANIM, ArtilleryEntity.newIntList(4));
    }

    protected static List<Integer> newIntList(int size) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            list.add(0);
        }
        return list;
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("ShootVecX", ((Vector3f)this.entityData.get(ArtilleryEntity.SHOOT_VEC)).x);
        compound.putFloat("ShootVecY", ((Vector3f)this.entityData.get(ArtilleryEntity.SHOOT_VEC)).y);
        compound.putFloat("ShootVecZ", ((Vector3f)this.entityData.get(ArtilleryEntity.SHOOT_VEC)).z);
        compound.putBoolean("Depressed", ((Boolean)this.entityData.get(DEPRESSED)).booleanValue());
        compound.putInt("Radius", ((Integer)this.entityData.get(RADIUS)).intValue());
        compound.putFloat("TargetX", ((Vector3f)this.entityData.get(ArtilleryEntity.TARGET_POS)).x);
        compound.putFloat("TargetY", ((Vector3f)this.entityData.get(ArtilleryEntity.TARGET_POS)).y);
        compound.putFloat("TargetZ", ((Vector3f)this.entityData.get(ArtilleryEntity.TARGET_POS)).z);
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("ShootVecX") && compound.contains("ShootVecY") && compound.contains("ShootVecZ")) {
            this.entityData.set(SHOOT_VEC, (Object)new Vector3f(compound.getFloat("ShootVecX"), compound.getFloat("ShootVecY"), compound.getFloat("ShootVecZ")));
        }
        if (compound.contains("Depressed")) {
            this.entityData.set(DEPRESSED, (Object)compound.getBoolean("Depressed"));
        }
        if (compound.contains("Radius")) {
            this.entityData.set(RADIUS, (Object)compound.getInt("Radius"));
        }
        if (compound.contains("TargetX") && compound.contains("TargetY") && compound.contains("TargetZ")) {
            this.entityData.set(TARGET_POS, (Object)new Vector3f(compound.getFloat("TargetX"), compound.getFloat("TargetX"), compound.getFloat("TargetZ")));
        }
    }

    public void setTarget(ItemStack stack, Entity entity, String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return;
        }
        FiringParameters.Parameters parameters = (FiringParameters.Parameters)stack.getOrDefault(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters());
        double targetX = parameters.pos().getX();
        double targetY = parameters.pos().getY();
        double targetZ = parameters.pos().getZ();
        boolean canAim = true;
        this.entityData.set(TARGET_POS, (Object)new Vector3f((float)targetX, (float)targetY, (float)targetZ));
        this.entityData.set(DEPRESSED, (Object)parameters.isDepressed());
        this.entityData.set(RADIUS, (Object)parameters.radius());
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.entityData.get(TARGET_POS)), (Integer)this.entityData.get(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getShootPos(weaponName, 1.0f), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.entityData.get(DEPRESSED));
        MutableComponent component = Component.literal((String)"");
        MutableComponent location = Component.translatable((String)"tips.superbwarfare.mortar.position", (Object[])new Object[]{this.getDisplayName()}).append((Component)Component.literal((String)(" X:" + FormatTool.format0D(this.getX()) + " Y:" + FormatTool.format0D(this.getY()) + " Z:" + FormatTool.format0D(this.getZ()) + " ")));
        if (launchVector == null) {
            canAim = false;
            component = Component.translatable((String)"tips.superbwarfare.mortar.out_of_range");
        } else {
            float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
            if (angle < -this.getTurretMaxPitch() || angle > -this.getTurretMinPitch()) {
                canAim = false;
                component = Component.translatable((String)"tips.superbwarfare.mortar.warn", (Object[])new Object[]{this.getDisplayName()});
                if (angle < -this.getTurretMaxPitch()) {
                    component = Component.translatable((String)"tips.superbwarfare.ballistics.warn");
                }
            }
        }
        if (canAim) {
            this.entityData.set(SHOOT_VEC, (Object)launchVector.toVector3f());
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            player.displayClientMessage((Component)location.copy().append((Component)component).withStyle(ChatFormatting.RED), false);
        }
    }

    public void resetTarget(String weaponName) {
        GunData data = this.getGunData(weaponName);
        if (data == null) {
            return;
        }
        Vec3 randomPos = VectorTool.randomPos(new Vec3((Vector3f)this.entityData.get(TARGET_POS)), (Integer)this.entityData.get(RADIUS));
        Vec3 launchVector = RangeTool.calculateLaunchVector(this.getShootPos(weaponName, 1.0f), randomPos, this.getProjectileVelocity(weaponName), this.getProjectileGravity(weaponName), (Boolean)this.entityData.get(DEPRESSED));
        if (launchVector == null) {
            return;
        }
        float angle = (float)(-VehicleVecUtils.getXRotFromVector(launchVector));
        if (angle > -this.getTurretMaxPitch() && angle < -this.getTurretMinPitch()) {
            this.entityData.set(SHOOT_VEC, (Object)launchVector.toVector3f());
        }
    }

    public int getMaxBarrel() {
        GunData data = this.getGunData("Main");
        if (data != null) {
            return data.compute().magazine;
        }
        return 1;
    }

    @Override
    public void baseTick() {
        Entity controller;
        ItemStack inStack;
        int count;
        Player player;
        int ammoCount;
        Entity entity;
        super.baseTick();
        for (int i = 0; i < this.getMaxBarrel(); ++i) {
            List animCounters = (List)this.entityData.get(BARREL_ANIM);
            if (i >= animCounters.size() || (Integer)animCounters.get(i) <= 0) continue;
            animCounters.set(i, (Integer)animCounters.get(i) - 1);
            this.entityData.set(BARREL_ANIM, (Object)animCounters, true);
        }
        GunData gunData = this.getGunData("Main");
        if (gunData != null && this.level() instanceof ServerLevel && (entity = this.getNthEntity(this.getTurretControllerIndex())) instanceof Player && (ammoCount = InventoryTool.countItem((Entity)(player = (Player)entity), gunData.selectedAmmoConsumer().stack().getItem())) > 0 && (count = (inStack = (ItemStack)this.items.getFirst()).getCount()) < Math.min((int)this.getMaxStackSize(), (int)inStack.getMaxStackSize())) {
            this.setItem(0, gunData.selectedAmmoConsumer().stack().copyWithCount(count + 1));
            InventoryTool.consumeItem((LivingEntity)player, gunData.selectedAmmoConsumer().stack().getItem(), 1);
        }
        if ((controller = this.getNthEntity(this.getTurretControllerIndex())) != null) {
            this.entityData.set(SHOOT_VEC, (Object)controller.getViewVector(1.0f).toVector3f());
        } else {
            this.turretAutoAimFromVector(new Vec3((Vector3f)this.entityData.get(SHOOT_VEC)));
        }
    }

    @Override
    public void vehicleShoot(LivingEntity living, String weaponName) {
        this.beforeShoot(living);
        super.vehicleShoot(living, weaponName);
    }

    @Override
    public void vehicleShoot(LivingEntity living, UUID uuid, Vec3 targetPos) {
        this.beforeShoot(living);
        super.vehicleShoot(living, uuid, targetPos);
    }

    public void beforeShoot(LivingEntity living) {
        Level level;
        GunData data = this.getGunData("Main");
        if (data != null && data.ammo.get() > 0) {
            List barrelAnim = (List)this.entityData.get(BARREL_ANIM);
            barrelAnim.set(data.ammo.get() - 1, data.compute().shootAnimationTime);
            this.entityData.set(BARREL_ANIM, (Object)barrelAnim, true);
        }
        if ((level = living.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            ParticleTool.spawnBigCannonMuzzleParticles(this.getShootVec("Main", 1.0f), this.getShootPos("Main", 1.0f), level2, this);
        }
    }
}

