/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.data.vehicle.subdata.EngineInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import com.atsuishio.superbwarfare.tools.VectorTool;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public final class VehicleEngineUtils {
    public static void trackEngine(VehicleEntity vehicle, EngineInfo.Track engineInfo) {
        int i;
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        double wheelDifferential = engineInfo.wheelDifferential;
        double trackSpeed = engineInfo.trackRotSpeed;
        double trackDifferential = engineInfo.trackDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        }
        if (vehicle.onGround()) {
            float f0 = 0.54f + 0.25f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.05 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.04 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        } else {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        Entity passenger0 = vehicle.getFirstPassenger();
        if (vehicle.getEnergy() <= energyCost) {
            return;
        }
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        }
        if (vehicle.forwardInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
        }
        if (vehicle.backInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            if (vehicle.rightInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
            } else if (vehicle.leftInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
            }
        } else if (vehicle.rightInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
        } else if (vehicle.leftInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
        }
        vehicle.targetSpeed = ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.getXRot() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.getXRot() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.upInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.6f));
        }
        if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.level() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.76f - (double)0.1f * vehicle.getDeltaMovement().horizontalDistance()), (double)0.3)));
        double s0 = vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - wheelRotSpeed * s0 + Mth.clamp((double)(wheelDifferential * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - wheelRotSpeed * s0 - Mth.clamp((double)(wheelDifferential * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setLeftTrack((float)((double)vehicle.getLeftTrack() - trackSpeed * java.lang.Math.PI * s0 + Mth.clamp((double)(trackDifferential * java.lang.Math.PI * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        vehicle.setRightTrack((float)((double)vehicle.getRightTrack() - trackSpeed * java.lang.Math.PI * s0 - Mth.clamp((double)(trackDifferential * java.lang.Math.PI * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0)));
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)vehicle.getEntityData().get(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)vehicle.getEntityData().get(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)vehicle.getEntityData().get(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        vehicle.setYRot((float)((double)vehicle.getYRot() - (vehicle.isInFluidType() && !vehicle.onGround() ? 2.5 : 6.0) * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - (double)i * s0));
        if (vehicle.isInFluidType() || vehicle.onGround()) {
            double water = !vehicle.isInFluidType() && !vehicle.onGround() ? 0.05f : (vehicle.isInFluidType() && !vehicle.onGround() ? 0.3f : 1.0f);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.15 * water * vehicle.targetSpeed * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void wheelEngine(VehicleEntity vehicle, EngineInfo.Wheel engineInfo) {
        int i;
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        double wheelDifferential = engineInfo.wheelDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        }
        if (vehicle.onGround()) {
            float f0 = 0.54f + 0.25f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.05 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.04 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        } else {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        Level level = vehicle.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (vehicle.isInFluidType() && vehicle.getDeltaMovement().length() > 0.1) {
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, vehicle.getX() + 0.5 * vehicle.getDeltaMovement().x, vehicle.getY() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2, vehicle.getZ() + 0.5 * vehicle.getDeltaMovement().z, (int)(2.0 + 4.0 * vehicle.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, vehicle.getX() + 0.5 * vehicle.getDeltaMovement().x, vehicle.getY() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2, vehicle.getZ() + 0.5 * vehicle.getDeltaMovement().z, (int)(2.0 + 10.0 * vehicle.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
            }
        }
        Entity passenger0 = vehicle.getFirstPassenger();
        if (vehicle.getEnergy() <= energyCost) {
            return;
        }
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        }
        if (vehicle.forwardInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
        }
        if (vehicle.backInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
        }
        vehicle.targetSpeed = ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.getXRot() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.getXRot() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.97f));
        }
        if (vehicle.upInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.6f));
        }
        if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.98f));
        }
        if (vehicle.level() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue() && ((Boolean)vehicle.getEntityData().get(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.93f));
            i = 0;
        } else if (((Boolean)vehicle.getEntityData().get(VehicleEntity.L_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = 3;
        } else if (((Boolean)vehicle.getEntityData().get(VehicleEntity.R_WHEEL_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.975f));
            i = -3;
        } else {
            i = 0;
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.875f));
        }
        if (vehicle.rightInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
        } else if (vehicle.leftInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
        }
        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.78f - 0.25 * vehicle.getDeltaMovement().horizontalDistance()), (double)0.1)));
        double s0 = vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - wheelRotSpeed * s0 - Mth.clamp((double)(wheelDifferential * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0) * vehicle.getDeltaMovement().length()));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - wheelRotSpeed * s0 + Mth.clamp((double)(wheelDifferential * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (double)-5.0, (double)5.0) * vehicle.getDeltaMovement().length()));
        vehicle.setRudderRot(Mth.clamp((float)(vehicle.getRudderRot() - ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
        vehicle.setYRot((float)((double)vehicle.getYRot() - Math.max((double)((double)(vehicle.isInFluidType() && !vehicle.onGround() ? 6 : 12) * vehicle.getDeltaMovement().horizontalDistance()), (double)0.0) * (double)vehicle.getRudderRot() * (double)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? 1 : -1) - (double)i * s0));
        if (vehicle.isInFluidType() || vehicle.onGround()) {
            double water = !vehicle.isInFluidType() && !vehicle.onGround() ? 0.05f : (vehicle.isInFluidType() && !vehicle.onGround() ? 0.3f : 1.0f);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.15 * water * vehicle.targetSpeed * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void shipEngine(VehicleEntity vehicle, EngineInfo.Ship engineInfo) {
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        double bodyPitchRate = engineInfo.bodyPitchRate;
        double bodyRollRate = engineInfo.bodyRollRate;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        }
        if (vehicle.onGround()) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.2, 0.99, 0.2));
        } else if (vehicle.isInFluidType()) {
            float f = (float)(0.75 - (double)0.04f * java.lang.Math.min(VehicleVecUtils.getSubmergedHeight(vehicle), (double)vehicle.getBbHeight()) + (double)(0.09f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.04 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f, 0.85, (double)f));
        } else {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        Level level = vehicle.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (vehicle.isInFluidType() && vehicle.getDeltaMovement().length() > 0.1) {
                double y = vehicle.getY() + VehicleVecUtils.getSubmergedHeight(vehicle) - 0.2;
                ParticleTool.sendParticle(serverLevel, ParticleTypes.CLOUD, vehicle.getX() + 0.5 * vehicle.getDeltaMovement().x, y, vehicle.getZ() + 0.5 * vehicle.getDeltaMovement().z, (int)(2.0 + 4.0 * vehicle.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, vehicle.getX() + 0.5 * vehicle.getDeltaMovement().x, y, vehicle.getZ() + 0.5 * vehicle.getDeltaMovement().z, (int)(2.0 + 10.0 * vehicle.getDeltaMovement().length()), 0.65, 0.0, 0.65, 0.0, true);
                ParticleTool.sendParticle(serverLevel, ParticleTypes.BUBBLE_COLUMN_UP, vehicle.getX() - 4.5 * vehicle.getLookAngle().x, vehicle.getY() - 0.25, vehicle.getZ() - 4.5 * vehicle.getLookAngle().z, (int)(40.0f * Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())), 0.15, 0.15, 0.15, 0.02, true);
            }
        }
        Entity passenger0 = vehicle.getFirstPassenger();
        if (vehicle.getEnergy() > energyCost) {
            if (passenger0 == null) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
            }
            if (vehicle.forwardInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)1.0f)));
            }
            if (vehicle.backInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            }
            vehicle.targetSpeed = ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)maxForwardSpeedRate : (double)maxBackwardSpeedRate;
            if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.97f));
            }
            if (vehicle.rightInputDown() || vehicle.leftInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.98f));
            }
            if (((Boolean)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.875f));
            }
            if (vehicle.level() instanceof ServerLevel) {
                vehicle.consumeEnergy(energyCost);
            }
            if (vehicle.rightInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - steeringSpeed));
            } else if (vehicle.leftInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + steeringSpeed));
            }
            vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * (float)Math.max((double)((double)0.78f - 0.25 * vehicle.getDeltaMovement().horizontalDistance()), (double)0.1)));
            vehicle.setPropellerRot(vehicle.getPropellerRot() + 2.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue());
            vehicle.setRudderRot(Mth.clamp((float)(vehicle.getRudderRot() - ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (float)-0.8f, (float)0.8f) * 0.75f);
            if (vehicle.isInFluidType() || vehicle.isUnderWater()) {
                vehicle.setXRot(vehicle.getXRot() * 0.85f);
                float direct = (90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f))) / 90.0f;
                vehicle.setXRot((float)((double)vehicle.getXRot() - (double)(direct * (float)(!vehicle.onGround() ? 1 : 0)) * bodyPitchRate * vehicle.getDeltaMovement().horizontalDistance()));
                vehicle.setYRot((float)((double)vehicle.getYRot() - 20.0 * vehicle.getDeltaMovement().horizontalDistance() * (double)((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * (double)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? 1 : -1)));
                vehicle.setZRot((float)((double)vehicle.getRoll() - (double)(direct * ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * (float)(!vehicle.onGround() ? 1 : 0)) * bodyRollRate * 10.0 * vehicle.getDeltaMovement().horizontalDistance()));
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.15 * vehicle.targetSpeed * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
            } else {
                vehicle.setXRot(vehicle.getXRot() * 0.99f);
            }
        }
        vehicle.setZRot(vehicle.getRoll() * 0.85f);
    }

    public static void helicopterEngine(VehicleEntity vehicle, EngineInfo.Helicopter engineInfo) {
        int energyCost = (int)engineInfo.energyCostRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        if (vehicle.onGround()) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.8, 1.0, 0.8));
        } else {
            vehicle.setZRot(vehicle.getRoll() * (vehicle.backInputDown() ? 0.9f : 0.99f));
            float f = (float)Mth.clamp((double)((double)0.95f - 0.015 * vehicle.getDeltaMovement().length() + (double)(0.02f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale((vehicle.getXRot() < 0.0f ? -0.035 : (vehicle.getXRot() > 0.0f ? 0.035 : 0.0)) * vehicle.getDeltaMovement().length())));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f, 0.95, (double)f));
        }
        if (vehicle.isInFluidType() && vehicle.tickCount % 4 == 0 && VehicleVecUtils.getSubmergedHeight(vehicle) > 0.5 * (double)vehicle.getBbHeight()) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            vehicle.hurt(ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), vehicle, vehicle.getFirstPassenger() == null ? vehicle : vehicle.getFirstPassenger()), 6.0f + (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
        }
        Entity pilot = vehicle.getFirstPassenger();
        boolean hasPassenger = false;
        for (int i = 0; i < vehicle.getMaxPassengers() - 1; ++i) {
            if (vehicle.getNthEntity(i) == null) continue;
            hasPassenger = true;
        }
        if (vehicle.getHealth() > 0.1f * vehicle.getMaxHealth()) {
            Vec3 landingPos = VehicleEngineUtils.findNearestLandingPos(vehicle, 30);
            if (pilot == null) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.setUpInputDown(false);
                vehicle.setDownInputDown(false);
                vehicle.setZRot(vehicle.getRoll() * 0.98f);
                vehicle.setXRot(vehicle.getXRot() * 0.98f);
                vehicle.getDeltaMovement().multiply(0.96, 0.98, 0.96);
                if (hasPassenger) {
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.99f));
                }
            } else {
                if (!vehicle.backInputDown() || landingPos == null) {
                    if (vehicle.rightInputDown()) {
                        ++vehicle.holdTick;
                        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - 2.0f * (float)Math.min((int)vehicle.holdTick, (int)7) * ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
                    } else if (vehicle.leftInputDown()) {
                        ++vehicle.holdTick;
                        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + 2.0f * (float)Math.min((int)vehicle.holdTick, (int)7) * ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
                    } else {
                        vehicle.holdTick = 0;
                    }
                    vehicle.setXRot(vehicle.getXRot() + (vehicle.onGround() ? 0.0f : 1.5f) * pitchSpeed * vehicle.getMouseMoveSpeedY() * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue());
                    vehicle.setZRot(vehicle.getRoll() - rollSpeed * (((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + (vehicle.onGround() ? 0.0f : 0.25f) * vehicle.getMouseMoveSpeedX() * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue()));
                }
                vehicle.setYRot(vehicle.getYRot() + yawSpeed * Mth.clamp((float)((vehicle.onGround() ? 0.1f : 2.0f) * vehicle.getMouseMoveSpeedX() * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue() + (float)((Boolean)vehicle.getEntityData().get(VehicleEntity.SUB_ENGINE_DAMAGED) != false ? 25 : 0) * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue()), (float)-10.0f, (float)10.0f));
                if (landingPos != null && !vehicle.onGround() && vehicle.backInputDown()) {
                    VehicleEngineUtils.updateAutoLanding(vehicle, landingPos);
                }
                if (pilot instanceof Player) {
                    Player player = (Player)pilot;
                    if (vehicle.level().isClientSide && landingPos != null && !vehicle.onGround()) {
                        player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.press_s_to_landing"), true);
                    }
                }
                if (vehicle.onGround()) {
                    vehicle.setZRot(vehicle.getRoll() * 0.98f);
                    vehicle.setXRot(vehicle.getXRot() * 0.98f);
                }
            }
            if (vehicle.getEnergy() > energyCost) {
                boolean up = vehicle.upInputDown() || vehicle.forwardInputDown();
                boolean down = vehicle.downInputDown();
                if (!vehicle.engineStart && up) {
                    vehicle.engineStart = true;
                    vehicle.level().playSound(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.getSoundSource(), 3.0f, 1.0f);
                }
                if (up && vehicle.engineStartOver) {
                    ++vehicle.holdPowerTick;
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + 7.0E-4f * powerAdd * (float)Math.min((int)vehicle.holdPowerTick, (int)10)), (float)0.12f)));
                }
                if (vehicle.engineStartOver) {
                    if (down) {
                        ++vehicle.holdPowerTick;
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 0.001f * powerReduce * (float)Math.min((int)vehicle.holdPowerTick, (int)5)), (float)(vehicle.onGround() ? 0.0f : 0.025f / lift))));
                    } else if (vehicle.backInputDown()) {
                        ++vehicle.holdPowerTick;
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 0.001f * powerReduce * (float)Math.min((int)vehicle.holdPowerTick, (int)5)), (float)(vehicle.onGround() ? 0.0f : 0.058f / lift))));
                    }
                }
                if (vehicle.engineStart && !vehicle.engineStartOver) {
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + 0.0012f * powerAdd), (float)0.045f)));
                }
                if (!up && !down && !vehicle.backInputDown() && vehicle.engineStartOver) {
                    if (vehicle.getDeltaMovement().y() < 0.0) {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + 2.0E-4f), (float)0.12f)));
                    } else {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - (vehicle.onGround() ? 5.0E-5f : 2.0E-4f)), (float)0.0f)));
                    }
                    vehicle.holdPowerTick = 0;
                }
            } else {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 1.0E-4f), (float)0.0f)));
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.engineStart = false;
                vehicle.engineStartOver = false;
            }
        } else if (!vehicle.onGround() && vehicle.engineStartOver) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 3.0E-4f), (float)0.01f)));
            vehicle.destroyRot += 0.08f;
            float diffX = 45.0f - vehicle.getXRot();
            float diffZ = -20.0f - vehicle.getRoll();
            vehicle.setXRot(vehicle.getXRot() + diffX * 0.05f * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue());
            vehicle.setYRot(vehicle.getYRot() + vehicle.destroyRot);
            vehicle.setZRot(vehicle.getRoll() + diffZ * 0.1f * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue());
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, (double)(-vehicle.destroyRot) * 0.004, 0.0));
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.98f));
        }
        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * 0.9f));
        vehicle.getEntityData().set(VehicleEntity.PROPELLER_ROT, (Object)Float.valueOf(Mth.lerp((float)0.18f, (float)((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue(), (float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
        vehicle.setPropellerRot(vehicle.getPropellerRot() + 30.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue());
        vehicle.getEntityData().set(VehicleEntity.PROPELLER_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue() * 0.9995f));
        if (vehicle.engineStart) {
            vehicle.consumeEnergy((int)((float)energyCost * 8.3333f * Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
        }
        Vec3 force = vehicle.getUpVec(1.0f);
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(force.scale((double)(((Float)vehicle.getEntityData().get(VehicleEntity.PROPELLER_ROT)).floatValue() * lift))));
        if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.04f) {
            vehicle.engineStartOver = true;
        }
        if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 4.0E-4f) {
            vehicle.engineStart = false;
            vehicle.engineStartOver = false;
        }
    }

    public static void aircraftEngine(VehicleEntity vehicle, EngineInfo.Aircraft engineInfo) {
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        float speedRate = engineInfo.speedRate;
        float gearRotateAngle = engineInfo.gearRotateAngle;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        float f = (float)Mth.clamp((double)(Math.max((double)((double)(vehicle.onGround() ? 0.819f : 0.82f) - 0.005 * vehicle.getDeltaMovement().length()), (double)0.5) + (double)(0.001f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
        boolean forward = vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) > 0.0;
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale((forward ? 0.227 : 0.1) * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f, (double)f, (double)f));
        if (vehicle.isInFluidType() && vehicle.tickCount % 4 == 0) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            if (vehicle.lastTickSpeed > 0.4) {
                vehicle.hurt(ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), vehicle, vehicle.getFirstPassenger() == null ? vehicle : vehicle.getFirstPassenger()), (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
            }
        }
        Entity passenger = vehicle.getFirstPassenger();
        if (vehicle.getHealth() > 0.1f * vehicle.getMaxHealth()) {
            if (passenger == null || vehicle.isInFluidType()) {
                vehicle.setLeftInputDown(false);
                vehicle.setRightInputDown(false);
                vehicle.setForwardInputDown(false);
                vehicle.setBackInputDown(false);
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.95f));
                if (vehicle.onGround()) {
                    vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.94, 1.0, 0.94));
                } else {
                    vehicle.setXRot(Mth.clamp((float)(vehicle.getXRot() + 0.1f), (float)-89.0f, (float)89.0f));
                }
            } else if (passenger instanceof Player) {
                if (vehicle.getEnergy() > energyCost) {
                    if (!vehicle.engineStart && vehicle.forwardInputDown()) {
                        vehicle.engineStart = true;
                        if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f) {
                            vehicle.level().playSound(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.getSoundSource(), 3.0f, 1.0f);
                        }
                    }
                    if (vehicle.forwardInputDown()) {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf((float)Mth.clamp((double)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + 0.0045f * powerAdd), (double)-0.1, (double)1.0)));
                    }
                    if (vehicle.backInputDown()) {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 0.006f * powerReduce), (float)(vehicle.onGround() ? -0.2f : 0.4f))));
                    }
                }
                if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.995f));
                }
                if (!vehicle.onGround()) {
                    if (vehicle.rightInputDown()) {
                        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - 0.6f));
                    } else if (vehicle.leftInputDown()) {
                        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + 0.6f));
                    }
                }
                if (vehicle.downInputDown()) {
                    if (vehicle.onGround()) {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.92f));
                        vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.97, 1.0, 0.97));
                    } else {
                        vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.97f));
                        vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.994, 1.0, 0.994));
                    }
                    vehicle.getEntityData().set(VehicleEntity.PLANE_BREAK, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue() + 10.0f), (float)60.0f)));
                }
            }
            if (vehicle.engineStart) {
                vehicle.consumeEnergy(energyCost);
            }
            float rotSpeed = 1.5f + 1.2f * Mth.abs((float)VectorTool.calculateY(vehicle.getRoll()));
            float addY = Mth.clamp((float)(Math.max((float)((vehicle.onGround() ? 0.6f : 0.2f) * (float)vehicle.getDeltaMovement().length()), (float)0.0f) * vehicle.getMouseMoveSpeedX()), (float)(-rotSpeed), (float)rotSpeed);
            float addX = Mth.clamp((float)(Math.min((float)((float)Math.max((double)(vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) - 0.24), (double)0.15)), (float)0.4f) * vehicle.getMouseMoveSpeedY()), (float)-3.5f, (float)3.5f);
            float addZ = ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - (vehicle.onGround() ? 0.0f : 0.004f) * vehicle.getMouseMoveSpeedX() * (float)vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f));
            vehicle.setYRot(vehicle.getYRot() + yawSpeed * addY);
            if (!vehicle.onGround()) {
                vehicle.setXRot(vehicle.getXRot() + pitchSpeed * addX);
                vehicle.setZRot(vehicle.getRoll() - rollSpeed * addZ);
            }
            if (!vehicle.onGround()) {
                float xSpeed = 1.0f + 20.0f * Mth.abs((float)(vehicle.getXRot() / 180.0f));
                float speed = Mth.clamp((float)(Mth.abs((float)vehicle.getRoll()) / (90.0f / xSpeed)), (float)0.0f, (float)1.0f);
                if (vehicle.getRoll() > 0.0f) {
                    vehicle.setZRot(vehicle.getRoll() - Math.min((float)speed, (float)vehicle.getRoll()));
                } else if (vehicle.getRoll() < 0.0f) {
                    vehicle.setZRot(vehicle.getRoll() + Math.min((float)speed, (float)(-vehicle.getRoll())));
                }
            }
            vehicle.setPropellerRot(vehicle.getPropellerRot() + 30.0f * ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue());
            if (engineInfo.hasGear) {
                if (vehicle.upInputDown()) {
                    vehicle.setUpInputDown(false);
                    if (((Float)vehicle.getEntityData().get(VehicleEntity.GEAR_ROT)).floatValue() == 0.0f && !vehicle.onGround()) {
                        vehicle.getEntityData().set(VehicleEntity.GEAR_UP, (Object)true);
                    } else if (((Float)vehicle.getEntityData().get(VehicleEntity.GEAR_ROT)).floatValue() == 1.0f) {
                        vehicle.getEntityData().set(VehicleEntity.GEAR_UP, (Object)false);
                    }
                }
                if (vehicle.onGround()) {
                    vehicle.getEntityData().set(VehicleEntity.GEAR_UP, (Object)false);
                }
                if (((Boolean)vehicle.getEntityData().get(VehicleEntity.GEAR_UP)).booleanValue()) {
                    vehicle.getEntityData().set(VehicleEntity.GEAR_ROT, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.GEAR_ROT)).floatValue() + 0.05f), (float)1.0f)));
                } else {
                    vehicle.getEntityData().set(VehicleEntity.GEAR_ROT, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.GEAR_ROT)).floatValue() - 0.05f), (float)0.0f)));
                }
                vehicle.setGearRot(((Float)vehicle.getEntityData().get(VehicleEntity.GEAR_ROT)).floatValue() * gearRotateAngle);
            }
            float flapX = (1.0f - Mth.abs((float)vehicle.getRoll()) / 90.0f) * Mth.clamp((float)vehicle.getMouseMoveSpeedY(), (float)-22.5f, (float)22.5f) - VectorTool.calculateY(vehicle.getRoll()) * Mth.clamp((float)vehicle.getMouseMoveSpeedX(), (float)-22.5f, (float)22.5f);
            vehicle.setFlap1LRot(Mth.clamp((float)(-flapX - 4.0f * addZ - ((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1RRot(Mth.clamp((float)(-flapX + 4.0f * addZ - ((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1L2Rot(Mth.clamp((float)(-flapX - 4.0f * addZ + ((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap1R2Rot(Mth.clamp((float)(-flapX + 4.0f * addZ + ((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue()), (float)-22.5f, (float)22.5f));
            vehicle.setFlap2LRot(Mth.clamp((float)(flapX - 4.0f * addZ), (float)-22.5f, (float)22.5f));
            vehicle.setFlap2RRot(Mth.clamp((float)(flapX + 4.0f * addZ), (float)-22.5f, (float)22.5f));
            float flapY = (1.0f - Mth.abs((float)vehicle.getRoll()) / 90.0f) * Mth.clamp((float)vehicle.getMouseMoveSpeedX(), (float)-22.5f, (float)22.5f) + VectorTool.calculateY(vehicle.getRoll()) * Mth.clamp((float)vehicle.getMouseMoveSpeedY(), (float)-22.5f, (float)22.5f);
            vehicle.setFlap3Rot(flapY * 5.0f);
        } else if (!vehicle.onGround()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 3.0E-4f), (float)0.02f)));
            vehicle.destroyRot += 0.1f;
            float diffX = 90.0f - vehicle.getXRot();
            vehicle.setXRot(vehicle.getXRot() + diffX * 0.001f * vehicle.destroyRot);
            vehicle.setZRot(vehicle.getRoll() - vehicle.destroyRot);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, -0.03, 0.0));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, (double)(-vehicle.destroyRot) * 0.005, 0.0));
        }
        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * 0.85f));
        vehicle.getEntityData().set(VehicleEntity.PLANE_BREAK, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.PLANE_BREAK)).floatValue() * 0.8f));
        if (vehicle.onGround()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.995f));
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.MAIN_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (((Boolean)vehicle.getEntityData().get(VehicleEntity.SUB_ENGINE_DAMAGED)).booleanValue()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        double flapAngle = (vehicle.getFlap1LRot() + vehicle.getFlap1RRot() + vehicle.getFlap1L2Rot() + vehicle.getFlap1R2Rot()) / 4.0f;
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getUpVec(1.0f).scale(vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) * 0.022 * (double)lift * (1.0 + Math.sin((double)((vehicle.onGround() ? 25.0 : flapAngle + 25.0) * 0.01745329238474369))))));
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.03 * (double)speedRate * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * (vehicle.sprintInputDown() ? 2.2 : 1.0))));
        if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.2f) {
            vehicle.engineStartOver = true;
        }
        if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 4.0E-4f) {
            vehicle.engineStart = false;
            vehicle.engineStartOver = false;
        }
    }

    public static void tomEngine(VehicleEntity vehicle, EngineInfo.Tom6 engineInfo) {
        Entity passenger;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float pitchSpeed = engineInfo.pitchSpeed;
        float yawSpeed = engineInfo.yawSpeed;
        float rollSpeed = engineInfo.rollSpeed;
        float lift = engineInfo.liftSpeed;
        float speedRate = engineInfo.speedRate;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        float f = (float)Mth.clamp((double)(Math.max((double)((double)(vehicle.onGround() ? 0.819f : 0.82f) - 0.005 * vehicle.getDeltaMovement().length()), (double)0.5) + (double)(0.001f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f)), (double)0.01, (double)0.99);
        boolean forward = vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) > 0.0;
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale((forward ? 0.227 : 0.1) * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f, (double)f, (double)f));
        if (vehicle.isInFluidType() && vehicle.tickCount % 4 == 0) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.6, 0.6, 0.6));
            if (vehicle.lastTickSpeed > 0.4) {
                vehicle.hurt(ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), vehicle, vehicle.getFirstPassenger() == null ? vehicle : vehicle.getFirstPassenger()), (float)(20.0 * ((vehicle.lastTickSpeed - 0.4) * (vehicle.lastTickSpeed - 0.4))));
            }
        }
        if ((passenger = vehicle.getFirstPassenger()) == null || vehicle.isInFluidType()) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.95f));
            if (vehicle.onGround()) {
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.94, 1.0, 0.94));
            } else {
                vehicle.setXRot(Mth.clamp((float)(vehicle.getXRot() + 0.1f), (float)-89.0f, (float)89.0f));
            }
        } else if (passenger instanceof Player) {
            if (vehicle.getEnergy() > energyCost) {
                if (!vehicle.engineStart && vehicle.forwardInputDown()) {
                    vehicle.engineStart = true;
                    if (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f) {
                        vehicle.level().playSound(null, (Entity)vehicle, engineInfo.engineStartSound, vehicle.getSoundSource(), 3.0f, 1.0f);
                    }
                }
                if (vehicle.forwardInputDown()) {
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf((float)Mth.clamp((double)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + 0.045f * powerAdd), (double)-0.1, (double)1.0)));
                }
                if (vehicle.backInputDown()) {
                    if (vehicle.onGround()) {
                        vehicle.setDeltaMovement(vehicle.getDeltaMovement().scale(0.97));
                    }
                    vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - 0.06f * powerReduce), (float)(vehicle.onGround() ? -0.6f : 0.2f))));
                }
            }
            float diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(passenger.getYHeadRot() - vehicle.getYRot())));
            float diffX = Math.clamp((float)-60.0f, (float)60.0f, (float)Mth.wrapDegrees((float)(passenger.getXRot() - vehicle.getXRot())));
            float roll = Mth.abs((float)Mth.clamp((float)(vehicle.getRoll() / 60.0f), (float)-1.5f, (float)1.5f));
            float addY = Mth.clamp((float)(Math.min((float)((vehicle.onGround() ? 1.5f : 0.9f) * (float)Math.max((double)(vehicle.getDeltaMovement().length() - 0.06), (double)0.1)), (float)0.9f) * diffY - 0.5f * ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue()), (float)(-3.0f * (roll + 1.0f)), (float)(3.0f * (roll + 1.0f)));
            float addX = Mth.clamp((float)(Math.min((float)((float)Math.max((double)(vehicle.getDeltaMovement().length() - 0.1), (double)0.01)), (float)0.9f) * diffX), (float)-4.0f, (float)4.0f);
            float addZ = ((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - (vehicle.onGround() ? 0.0f : 0.01f) * diffY * (float)vehicle.getDeltaMovement().length();
            float i = vehicle.getXRot() / 90.0f;
            float yRotSync = addY * (1.0f - Mth.abs((float)i)) + addZ * i;
            vehicle.setYRot(vehicle.getYRot() + yRotSync * yawSpeed);
            vehicle.setXRot(Mth.clamp((float)(vehicle.getXRot() + addX * pitchSpeed), (float)(vehicle.onGround() ? -12.0f : -120.0f), (float)(vehicle.onGround() ? 3.0f : 120.0f)));
            vehicle.setZRot(vehicle.getRoll() - addZ * (1.0f - Mth.abs((float)i)) * rollSpeed);
            if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.995f));
            }
            if (!vehicle.onGround()) {
                if (vehicle.rightInputDown()) {
                    vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() - 0.6f));
                } else if (vehicle.leftInputDown()) {
                    vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() + 0.6f));
                }
            }
        }
        vehicle.consumeEnergy(energyCost);
        if (!vehicle.onGround()) {
            float xSpeed = 1.0f + 20.0f * Mth.abs((float)(vehicle.getXRot() / 180.0f));
            float speed = Mth.clamp((float)(Mth.abs((float)vehicle.getRoll()) / (90.0f / xSpeed)), (float)0.0f, (float)1.0f);
            if (vehicle.getRoll() > 0.0f) {
                vehicle.setZRot(vehicle.getRoll() - Math.min((float)speed, (float)vehicle.getRoll()));
            } else if (vehicle.getRoll() < 0.0f) {
                vehicle.setZRot(vehicle.getRoll() + Math.min((float)speed, (float)(-vehicle.getRoll())));
            }
        }
        vehicle.getEntityData().set(VehicleEntity.DELTA_ROT, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.DELTA_ROT)).floatValue() * 0.85f));
        if (vehicle.onGround()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.995f));
        }
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getUpVec(1.0f).scale(vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)) * 0.022 * (double)lift * (double)(1.0f + Math.sin((float)((float)(vehicle.onGround() ? 25 : 30) * ((float)java.lang.Math.PI / 180)))))));
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.02 * (double)speedRate * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * (vehicle.sprintInputDown() ? 2.2 : 1.0))));
    }

    public static void wheelChairEngine(VehicleEntity vehicle, EngineInfo.WheelChair engineInfo) {
        double buoyancy = engineInfo.buoyancy;
        int energyCost = (int)(engineInfo.energyCostRate * (double)Mth.abs((float)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue()));
        double wheelRotSpeed = engineInfo.wheelRotSpeed;
        float wheelDifferential = (float)engineInfo.wheelDifferential;
        float maxForwardSpeedRate = engineInfo.maxForwardSpeedRate;
        float maxBackwardSpeedRate = engineInfo.maxBackwardSpeedRate;
        float powerAdd = engineInfo.increment;
        float powerReduce = engineInfo.decrement;
        float steeringSpeed = engineInfo.steeringSpeed;
        float bodyRollRate = (float)engineInfo.bodyRollRate;
        int jumpEnergyCost = engineInfo.jumpEnergyCost;
        if (buoyancy != 0.0) {
            double fluidFloat = buoyancy * VehicleVecUtils.getSubmergedHeight(vehicle);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, fluidFloat, 0.0));
        }
        if (vehicle.onGround()) {
            float f0 = 0.63f + 0.25f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.05 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f0, 0.99, (double)f0));
        } else if (vehicle.isInFluidType()) {
            float f1 = 0.74f + 0.09f * Mth.abs((float)(90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f)))) / 90.0f;
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).normalize().scale(0.04 * vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f)))));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply((double)f1, 0.85, (double)f1));
        } else {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.99, 0.99, 0.99));
        }
        vehicle.setSprinting(vehicle.getDeltaMovement().horizontalDistance() > 0.15);
        Entity passenger0 = vehicle.getFirstPassenger();
        float diffY = 0.0f;
        if (passenger0 == null) {
            vehicle.setLeftInputDown(false);
            vehicle.setRightInputDown(false);
            vehicle.setForwardInputDown(false);
            vehicle.setBackInputDown(false);
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(0.0f));
        } else {
            diffY = Math.clamp((float)-90.0f, (float)90.0f, (float)Mth.wrapDegrees((float)(passenger0.getYHeadRot() - vehicle.getYRot())));
            vehicle.setYRot(vehicle.getYRot() + Mth.clamp((float)(0.4f * diffY), (float)(-5.0f * steeringSpeed), (float)(5.0f * steeringSpeed)));
            float direct = (90.0f - (float)VehicleVecUtils.calculateAngle(vehicle.getDeltaMovement(), vehicle.getViewVector(1.0f))) / 90.0f;
            vehicle.setZRot((float)((double)vehicle.getRoll() + (double)(direct * diffY) * 0.1 * (double)bodyRollRate * vehicle.getDeltaMovement().length()));
        }
        if (vehicle.forwardInputDown()) {
            if (vehicle.getEnergy() <= 0 && passenger0 instanceof Player) {
                Player player = (Player)passenger0;
                VehicleEngineUtils.moveWithOutPower(vehicle, player, true);
            } else {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.min((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() + (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() < 0.0f ? powerAdd * 2.0f : powerAdd)), (float)(vehicle.sprintInputDown() ? 2.0f : 1.0f))));
            }
        }
        if (vehicle.backInputDown()) {
            if (vehicle.getEnergy() <= 0 && passenger0 instanceof Player) {
                Player player = (Player)passenger0;
                VehicleEngineUtils.moveWithOutPower(vehicle, player, false);
            } else {
                vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(Math.max((float)(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() - (((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? powerReduce * 2.0f : powerReduce)), (float)-1.0f)));
            }
        }
        vehicle.targetSpeed = ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() > 0.0f ? (double)(maxForwardSpeedRate * (1.0f + vehicle.getXRot() / 55.0f)) : (double)(maxBackwardSpeedRate * (1.0f - vehicle.getXRot() / 55.0f));
        if (!vehicle.forwardInputDown() && !vehicle.backInputDown()) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.96f));
        }
        if (vehicle.upInputDown() && vehicle.onGround() && vehicle.getEnergy() > jumpEnergyCost && vehicle.jumpCoolDown == 0 && engineInfo.canJump) {
            if (passenger0 instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger0;
                serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.WHEEL_CHAIR_JUMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            vehicle.consumeEnergy(jumpEnergyCost);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getUpVec(1.0f).scale(engineInfo.jumpForce)));
            vehicle.jumpCoolDown = engineInfo.jumpCoolDown;
        }
        if (vehicle.level() instanceof ServerLevel) {
            vehicle.consumeEnergy(energyCost);
        }
        double s0 = vehicle.getDeltaMovement().dot(vehicle.getViewVector(1.0f));
        vehicle.setLeftWheelRot((float)((double)vehicle.getLeftWheelRot() - 1.25 * wheelRotSpeed * s0) - 0.015f * wheelDifferential * Mth.clamp((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        vehicle.setRightWheelRot((float)((double)vehicle.getRightWheelRot() - 1.25 * wheelRotSpeed * s0) + 0.015f * wheelDifferential * Mth.clamp((float)(0.4f * diffY), (float)-5.0f, (float)5.0f));
        if (vehicle.isInFluidType() || vehicle.onGround()) {
            double water = !vehicle.isInFluidType() && !vehicle.onGround() ? 0.05f : (vehicle.isInFluidType() && !vehicle.onGround() ? 0.3f : 1.0f);
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(0.08 * water * vehicle.targetSpeed * (double)((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue())));
        }
    }

    public static void moveWithOutPower(VehicleEntity vehicle, Player player, boolean forward) {
        vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(vehicle.getViewVector(1.0f).scale(forward ? (double)0.1f : (double)-0.1f)));
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), SoundEvents.BOAT_PADDLE_LAND, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.causeFoodExhaustion(0.03f);
        vehicle.setForwardInputDown(false);
        vehicle.setBackInputDown(false);
    }

    public static Vec3 findNearestLandingPos(VehicleEntity entity, int radius) {
        Level world = entity.level();
        BlockPos entityPos = entity.blockPosition();
        ArrayList<BlockPos> landingBlocks = new ArrayList<BlockPos>();
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                for (int y = -radius; y <= 0; ++y) {
                    BlockPos checkPos;
                    if (x * x + y * y + z * z > radius * radius || !world.getBlockState(checkPos = entityPos.offset(x, y, z)).is(ModTags.Blocks.AUTO_LANDING)) continue;
                    landingBlocks.add(checkPos);
                }
            }
        }
        if (landingBlocks.isEmpty()) {
            return null;
        }
        landingBlocks.sort(Comparator.comparingDouble(pos -> entity.position().distanceToSqr((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5)));
        return ((BlockPos)landingBlocks.getFirst()).getCenter();
    }

    public static void updateAutoLanding(VehicleEntity entity, Vec3 landingTarget) {
        Vec3 currentPos = entity.position();
        Vec3 horizontalOffset = new Vec3(landingTarget.x - currentPos.x, 0.0, landingTarget.z - currentPos.z);
        entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.975, 0.99, 0.975));
        double horizontalDistance = horizontalOffset.length();
        Vec3 horizontalDirection = horizontalDistance > 0.0 ? horizontalOffset.normalize() : Vec3.ZERO;
        float tiltSmoothingFactor = 0.1f;
        double horizontalDistanceNew = horizontalDistance - 5.0 * entity.getDeltaMovement().horizontalDistance();
        float maxTiltAngle = 15.0f;
        float targetTilt = (float)Math.min((double)maxTiltAngle, (double)(horizontalDistanceNew * 2.0));
        float yawRad = Math.toRadians((float)(-entity.getYRot()));
        Vec3 localDirection = new Vec3(horizontalDirection.x * (double)Math.cos((float)yawRad) - horizontalDirection.z * (double)Math.sin((float)yawRad), 0.0, horizontalDirection.x * (double)Math.sin((float)yawRad) + horizontalDirection.z * (double)Math.cos((float)yawRad));
        float targetXRot = (float)(-localDirection.z * (double)targetTilt);
        float targetZRot = (float)(localDirection.x * (double)targetTilt);
        entity.setXRot(VehicleEngineUtils.lerpAngle(entity.getXRot(), -targetXRot, tiltSmoothingFactor));
        entity.setZRot(VehicleEngineUtils.lerpAngle(entity.getRoll(), -targetZRot, tiltSmoothingFactor));
    }

    public static float lerpAngle(float current, float target, float factor) {
        float diff;
        for (diff = target - current; diff < -180.0f; diff += 360.0f) {
        }
        while (diff > 180.0f) {
            diff -= 360.0f;
        }
        return current + diff * factor;
    }
}

