/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.entity.vehicle.utils;

import com.atsuishio.superbwarfare.config.server.VehicleConfig;
import com.atsuishio.superbwarfare.data.vehicle.subdata.CollisionLevel;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Type63Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleEngineUtils;
import com.atsuishio.superbwarfare.entity.vehicle.utils.VehicleVecUtils;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModMobEffects;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.DamageHandler;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.VectorTool;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector4d;

public final class VehicleMotionUtils {
    public static void preventStacking(VehicleEntity vehicle) {
        List entities = vehicle.level().getEntities(EntityTypeTest.forClass(VehicleEntity.class), vehicle.getBoundingBox().inflate(6.0), entity -> entity != vehicle && entity != vehicle.getFirstPassenger() && entity.getVehicle() == null);
        for (VehicleEntity entity2 : entities) {
            if (!entity2.getBoundingBox().intersects(vehicle.getBoundingBox())) continue;
            Vec3 toVec = vehicle.position().add(new Vec3(1.0, 1.0, 1.0).scale((double)(vehicle.getRandom().nextFloat() * 0.01f + 1.0f))).vectorTo(entity2.position());
            Vec3 velAdd = toVec.normalize().scale(Math.max((double)((double)(vehicle.getBbWidth() + 2.0f) - vehicle.position().distanceTo(entity2.position())), (double)0.0) * 0.1);
            double entitySize = entity2.getBbWidth() * entity2.getBbHeight();
            double thisSize = vehicle.getBbWidth() * vehicle.getBbHeight();
            double f = Math.min((double)(entitySize / thisSize), (double)2.0);
            double f1 = Math.min((double)(thisSize / entitySize), (double)2.0);
            vehicle.pushNew(-f * velAdd.x, -f * velAdd.y, -f * velAdd.z);
            entity2.push(f1 * velAdd.x, f1 * velAdd.y, f1 * velAdd.z);
        }
    }

    public static void supportEntities(VehicleEntity vehicle) {
        if (vehicle.isRemoved()) {
            return;
        }
        if (vehicle.enableAABB() || vehicle instanceof Type63Entity) {
            return;
        }
        AABB frontBox = VehicleMotionUtils.calculateCombinedAABBOptimized(vehicle).inflate(1.0);
        List<Entity> entities = vehicle.level().getEntities(EntityTypeTest.forClass(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.getFirstPassenger() && entity.getVehicle() == null).stream().filter(entity -> {
            if (entity.isAlive() && vehicle.isInObb((Entity)entity, vehicle.getDeltaMovement())) {
                Player player;
                LivingEntity living;
                ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).isSpectator()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
            }
            return false;
        }).toList();
        entities.forEach(e -> {
            if (e instanceof Player) {
                Player player = (Player)e;
                if (vehicle.level().isClientSide) {
                    vehicle.support((Entity)player);
                    return;
                }
            }
            if (vehicle.level().isClientSide) return;
            vehicle.support((Entity)e);
        });
    }

    public static void support(VehicleEntity vehicle, Entity entity) {
        if (vehicle.enableAABB()) {
            return;
        }
        if (entity.noPhysics || vehicle.noPhysics) {
            return;
        }
        Vec3 feetPos = entity.position().subtract(new Vec3(0.0, (double)0.1f, 0.0));
        Vec3 midPos = feetPos.add(0.0, (double)(entity.getEyeHeight() / 2.0f), 0.0);
        Vec3 eyePos = feetPos.add(0.0, (double)entity.getEyeHeight(), 0.0);
        for (OBB obb : vehicle.getOBBs()) {
            double dz;
            double dx;
            double dMax;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).onGround() && player.isCrouching() && player.level() instanceof ServerLevel) {
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().add(player.getForward()).normalize().scale(player.getDeltaMovement().length() * 3.0));
            }
            if (obb.contains(feetPos) && !entity.noPhysics && !vehicle.noPhysics) {
                double gravity = Math.max((double)entity.getDeltaMovement().y, (double)0.0);
                if (gravity == 0.0) {
                    entity.setOnGround(true);
                }
                double depth = obb.getEmbeddingDepth(feetPos);
                entity.setDeltaMovement(vehicle.getDeltaMovement().add(0.0, gravity + depth <= (double)0.4f ? 0.0 : depth * 1.1, 0.0));
                entity.fallDistance = 0.0f;
                continue;
            }
            if (obb.contains(eyePos) && (dMax = Mth.absMax((double)(dx = entity.getX() - obb.center().x), (double)(dz = entity.getZ() - obb.center().z))) >= (double)0.01f) {
                dMax = Math.sqrt((double)dMax);
                dx /= dMax;
                dz /= dMax;
                double d = 1.0 / dMax;
                if (d > 1.0) {
                    d = 1.0;
                }
                dx *= d;
                dz *= d;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.isPushable()) continue;
                entity.push(dx, 0.0, dz);
                continue;
            }
            AABB aabb = entity.getBoundingBox();
            if (!OBB.isColliding(obb, aabb)) continue;
            int face = obb.getEmbeddingFace(midPos);
            Vector3d[] axes = obb.getAxes();
            Vector3d support = axes[Math.abs((int)face) - 1];
            if (face < 0) {
                support.negate();
            }
            if (!entity.isPushable()) continue;
            float force = 0.1f;
            if (vehicle.getDeltaMovement().length() > 0.01 && Math.abs((int)face) != 2) {
                force = 0.2f;
            }
            Vec3 vec = OBB.vector3dToVec3(support).scale((double)force);
            vec = new Vec3(vec.x, Math.max((double)0.0, (double)vec.y), vec.z);
            entity.setPos(entity.position().add(vec));
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(0.2, 0.2, 0.2));
            vehicle.hasImpulse = true;
        }
    }

    public static void crushEntities(VehicleEntity vehicle) {
        List<Entity> entities;
        if (!vehicle.canCrushEntities()) {
            return;
        }
        if (vehicle.isRemoved()) {
            return;
        }
        Vec3 vec3 = vehicle.getDeltaMovement();
        if (!vehicle.enableAABB()) {
            frontBox = vehicle.getBoundingBox().move(vec3).inflate(6.0);
            entities = vehicle.level().getEntities(EntityTypeTest.forClass(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.getFirstPassenger() && entity.getVehicle() == null).stream().filter(entity -> {
                if (entity.isAlive() && vehicle.isInObb((Entity)entity, vec3)) {
                    Player player;
                    LivingEntity living;
                    ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                    return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).isSpectator()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                }
                return false;
            }).toList();
        } else {
            frontBox = vehicle.getBoundingBox().move(vec3);
            entities = vehicle.level().getEntities(EntityTypeTest.forClass(Entity.class), frontBox, entity -> entity != vehicle && entity != vehicle.getFirstPassenger() && entity.getVehicle() == null).stream().filter(entity -> {
                if (entity.isAlive()) {
                    Player player;
                    LivingEntity living;
                    ResourceLocation type = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                    return entity instanceof VehicleEntity || entity instanceof Boat || entity instanceof Minecart || entity instanceof LivingEntity && (!((living = (LivingEntity)entity) instanceof Player) || !(player = (Player)living).isSpectator()) || ((List)VehicleConfig.COLLISION_ENTITY_WHITELIST.get()).contains(type.toString());
                }
                return false;
            }).toList();
        }
        for (Entity entity2 : entities) {
            Vec3 vec31;
            double f1;
            double f;
            LivingEntity living;
            double entitySize = entity2.getBoundingBox().getSize();
            double thisSize = vehicle.getBoundingBox().getSize();
            Vec3 v0 = vec3.subtract(entity2.getDeltaMovement());
            if (VectorTool.calculateAngle(v0, vehicle.position().vectorTo(entity2.position())) > 90.0) {
                return;
            }
            if (vehicle.getDeltaMovement().lengthSqr() < 0.09) {
                return;
            }
            if (entity2 instanceof LivingEntity && (living = (LivingEntity)entity2).hasEffect(ModMobEffects.STRIKE_PROTECTION)) continue;
            if (entity2 instanceof VehicleEntity) {
                VehicleEntity v = (VehicleEntity)entity2;
                f = Mth.clamp((double)(v.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
                f1 = Mth.clamp((double)(vehicle.getMass() / vehicle.getMass()), (double)0.25, (double)4.0);
            } else {
                f = Mth.clamp((double)(entitySize / thisSize), (double)0.25, (double)4.0);
                f1 = Mth.clamp((double)(thisSize / entitySize), (double)0.25, (double)4.0);
            }
            float length = (float)v0.length();
            Vec3 velAdd = v0.normalize().scale(0.8 * (double)length);
            if ((double)length <= 0.3) continue;
            vehicle.level().playSound(null, (Entity)vehicle, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), vehicle.getSoundSource(), 1.0f, 1.0f);
            if (entity2 instanceof LivingEntity) {
                DamageHandler.doDamage(entity2, ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), vehicle, vehicle.getFirstPassenger() == null ? vehicle : vehicle.getFirstPassenger()), (float)(f1 * 80.0 * ((double)Mth.abs((float)length) - 0.3) * ((double)Mth.abs((float)length) - 0.3)));
            } else {
                entity2.hurt(ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), vehicle, vehicle.getFirstPassenger() == null ? vehicle : vehicle.getFirstPassenger()), (float)(f1 * 60.0 * ((double)Mth.abs((float)length) - 0.3) * ((double)Mth.abs((float)length) - 0.3)));
            }
            if (!(entity2 instanceof TargetEntity)) {
                vehicle.pushNew((double)-0.3f * f * velAdd.x, (double)-0.3f * f * velAdd.y, (double)-0.3f * f * velAdd.z);
            }
            if (entity2 instanceof VehicleEntity) {
                VehicleEntity mobileVehicle = (VehicleEntity)entity2;
                vehicle.hurt(ModDamageTypes.causeVehicleStrikeDamage(vehicle.level().registryAccess(), entity2, entity2.getFirstPassenger() == null ? entity2 : entity2.getFirstPassenger()), (float)(f * 40.0 * ((double)Mth.abs((float)length) - 0.3) * ((double)Mth.abs((float)length) - 0.3)));
                if (!vehicle.enableAABB() && vehicle.isInObb(entity2, Vec3.ZERO)) {
                    Vec3 thisPos = vehicle.position();
                    Vec3 otherPos = entity2.position();
                    for (OBB obb : vehicle.getOBBs()) {
                        if (!mobileVehicle.enableAABB()) {
                            List<OBB> obbList2 = mobileVehicle.getOBBs();
                            for (OBB obb2 : obbList2) {
                                if (!OBB.isColliding(obb, obb2)) continue;
                                thisPos = OBB.vector3dToVec3(obb.center());
                                otherPos = OBB.vector3dToVec3(obb2.center());
                            }
                            continue;
                        }
                        if (!OBB.isColliding(obb, entity2.getBoundingBox())) continue;
                        thisPos = OBB.vector3dToVec3(obb.center());
                    }
                    Vec3 toVec = thisPos.add(new Vec3(1.0, 1.0, 1.0).scale((double)(vehicle.getRandom().nextFloat() * 0.01f + 1.0f))).vectorTo(otherPos);
                    velAdd = toVec.normalize().scale(Math.max((double)thisPos.distanceTo(otherPos), (double)0.0) * 0.01);
                    vehicle.pushNew(-f * velAdd.x, -f * velAdd.y, -f * velAdd.z);
                }
                vec31 = vehicle.getDeltaMovement().normalize().scale(velAdd.length());
                mobileVehicle.pushNew(f1 * vec31.x, f1 * vec31.y, f1 * vec31.z);
                continue;
            }
            vec31 = vehicle.getDeltaMovement().normalize().scale(velAdd.length());
            entity2.push(f1 * vec31.x, f1 * vec31.y, f1 * vec31.z);
        }
    }

    public static AABB calculateCombinedAABBOptimized(VehicleEntity vehicle) {
        if (vehicle.enableAABB()) {
            return vehicle.getBoundingBox();
        }
        List<OBB> obbList = vehicle.getOBBs();
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (OBB obb : obbList) {
            Vector3d[] vertices;
            for (Vector3d vertex : vertices = obb.getVertices()) {
                min.x = Math.min((double)min.x, (double)vertex.x);
                min.y = Math.min((double)min.y, (double)vertex.y);
                min.z = Math.min((double)min.z, (double)vertex.z);
                max.x = Math.max((double)max.x, (double)vertex.x);
                max.y = Math.max((double)max.y, (double)vertex.y);
                max.z = Math.max((double)max.z, (double)vertex.z);
            }
        }
        return new AABB(OBB.vector3dToVec3(min), OBB.vector3dToVec3(max));
    }

    public static void collideBlocks(VehicleEntity vehicle) {
        CollisionLevel collisionLevel = vehicle.computed().collisionLevel;
        List<CollisionLevel.Limit> limits = collisionLevel.powerLimits;
        float power = ((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue();
        double motion = vehicle.getDeltaMovement().horizontalDistance();
        boolean[] flags = new boolean[]{(Boolean)VehicleConfig.COLLISION_DESTROY_SOFT_BLOCKS.get() != false && collisionLevel.level >= 1, (Boolean)VehicleConfig.COLLISION_DESTROY_NORMAL_BLOCKS.get() != false && collisionLevel.level >= 2, (Boolean)VehicleConfig.COLLISION_DESTROY_HARD_BLOCKS.get() != false && collisionLevel.level >= 3, (Boolean)VehicleConfig.COLLISION_DESTROY_BLOCKS_BEASTLY.get() != false && collisionLevel.level >= 4};
        for (int i = 0; i < flags.length && i < limits.size(); ++i) {
            CollisionLevel.Limit limit = limits.get(i);
            int n = i;
            flags[n] = flags[n] & (limit.equals() ? power >= limit.power() || motion >= (double)limit.motion() : power > limit.power() || motion > (double)limit.motion());
        }
        if (!vehicle.enableAABB()) {
            AABB aabb = vehicle.getBoundingBox().move(vehicle.getDeltaMovement()).inflate(5.0);
            BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
                BlockState blockstate = vehicle.level().getBlockState(pos);
                if (vehicle.isInObb((BlockPos)pos, vehicle.getDeltaMovement()) && (flags[0] && blockstate.is(ModTags.Blocks.SOFT_COLLISION) || flags[1] && blockstate.is(ModTags.Blocks.NORMAL_COLLISION) || flags[2] && blockstate.is(ModTags.Blocks.HARD_COLLISION) || flags[3] && (blockstate.getBlock().defaultDestroyTime() > 0.0f || blockstate.getBlock().defaultDestroyTime() <= 4.0f))) {
                    vehicle.level().destroyBlock(pos, true);
                }
            });
        }
        AABB aabb = vehicle.getBoundingBox().inflate(0.25, 0.0, 0.25).move(vehicle.getDeltaMovement()).move(0.0, 0.5, 0.0);
        BlockPos.betweenClosedStream((AABB)aabb).forEach(pos -> {
            BlockState blockstate = vehicle.level().getBlockState(pos);
            if (flags[0] && blockstate.is(ModTags.Blocks.SOFT_COLLISION) || flags[1] && blockstate.is(ModTags.Blocks.NORMAL_COLLISION) || flags[2] && blockstate.is(ModTags.Blocks.HARD_COLLISION) || flags[3] && (blockstate.getBlock().defaultDestroyTime() > 0.0f || blockstate.getBlock().defaultDestroyTime() <= 4.0f)) {
                vehicle.level().destroyBlock(pos, true);
            }
        });
    }

    public static void handleVehicleMoveOnDragonTeeth(VehicleEntity vehicle) {
        AABB aabb = vehicle.getBoundingBox();
        AABB aabb1 = new AABB(aabb.minX, aabb.minY - 1.0E-6, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ);
        BlockPos pos = vehicle.level().findSupportingBlock((Entity)vehicle, aabb1).orElse(null);
        if (pos == null) {
            return;
        }
        BlockState state = vehicle.level().getBlockState(pos);
        if (state.is((Block)ModBlocks.DRAGON_TEETH.get())) {
            vehicle.getEntityData().set(VehicleEntity.POWER, (Object)Float.valueOf(((Float)vehicle.getEntityData().get(VehicleEntity.POWER)).floatValue() * 0.8f));
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(-0.1, 0.0, -0.1));
        }
    }

    public static void bounceHorizontal(VehicleEntity vehicle, Direction direction) {
        switch (direction.getAxis()) {
            case X: {
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.8, 0.99, 0.99));
                break;
            }
            case Z: {
                vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.99, 0.99, 0.8));
            }
        }
    }

    public static void bounceVertical(VehicleEntity vehicle, Direction direction) {
        if (!vehicle.level().isClientSide) {
            vehicle.level().playSound(null, (Entity)vehicle, (SoundEvent)ModSounds.VEHICLE_STRIKE.get(), vehicle.getSoundSource(), 1.0f, 1.0f);
        }
        vehicle.collisionCoolDown = 4;
        vehicle.setCrash(true);
        if (direction.getAxis() == Direction.Axis.Y) {
            vehicle.setDeltaMovement(vehicle.getDeltaMovement().multiply(0.9, -0.8, 0.9));
        }
    }

    public static void terrainCompact(VehicleEntity vehicle, List<Vec3> positions) {
        if (vehicle.onGround()) {
            Matrix4d transform = vehicle.getWheelsTransform(1.0f);
            for (Vec3 vec3 : positions) {
                BlockState state;
                VoxelShape shape;
                Vector4d Vector4d2 = VehicleVecUtils.transformPosition(transform, vec3.x, vec3.y - 0.02, vec3.z);
                Vec3 p = new Vec3(Vector4d2.x, Vector4d2.y, Vector4d2.z);
                Level level = vehicle.level();
                BlockHitResult res = level.clip(new ClipContext(p, p.add(0.0, -512.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)vehicle));
                BlockPos blockPos = BlockPos.containing((Position)p);
                BlockPos blockPosUp = BlockPos.containing((Position)p.add(0.0, 1.0, 0.0));
                if (level.getBlockState(blockPosUp).canOcclude()) {
                    blockPos = blockPosUp;
                }
                double heightY = !(shape = (state = level.getBlockState(blockPos)).getCollisionShape((BlockGetter)level, blockPos)).isEmpty() ? p.y - (shape.max(Direction.Axis.Y) + (double)blockPos.getY()) : (res.getType() == HitResult.Type.BLOCK && level.noCollision(new AABB(p, p)) ? Mth.clamp((double)(p.y - res.getLocation().y), (double)0.0, (double)20.0) : 0.0);
                VehicleMotionUtils.updateTerrainCompact(vehicle, p, heightY);
            }
        } else if (vehicle.isInFluidType()) {
            vehicle.setXRot(vehicle.getXRot() * 0.9f);
            vehicle.setZRot(vehicle.getRoll() * 0.9f);
        }
    }

    public static void updateTerrainCompact(VehicleEntity entity, Vec3 landingTarget, double heightY) {
        Vec3 horizontalOffset;
        double horizontalDistance;
        Vec3 currentPos = entity.position();
        AABB aabb = entity.getBoundingBox();
        AABB aabb1 = new AABB(aabb.minX, aabb.minY - 1.0E-6, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ);
        Optional optional = entity.level().findSupportingBlock((Entity)entity, aabb1);
        if (optional.isPresent()) {
            currentPos = currentPos.add(currentPos.vectorTo(((BlockPos)optional.get()).getCenter()).scale(0.6));
        }
        Vec3 horizontalDirection = (horizontalDistance = (horizontalOffset = new Vec3(landingTarget.x - currentPos.x, 0.0, landingTarget.z - currentPos.z)).length()) > 0.0 ? horizontalOffset.normalize() : Vec3.ZERO;
        float tiltSmoothingFactor = 0.03f;
        float targetTilt = (float)Math.min((double)(heightY * 9.0 * (double)entity.data().compute().terrainCompatRotateRate * horizontalDistance), (double)45.0);
        float yawRad = Math.toRadians((float)(-entity.getYRot()));
        Vec3 localDirection = new Vec3(horizontalDirection.x * (double)Math.cos((float)yawRad) - horizontalDirection.z * (double)Math.sin((float)yawRad), 0.0, horizontalDirection.x * (double)Math.sin((float)yawRad) + horizontalDirection.z * (double)Math.cos((float)yawRad));
        float targetXRot = (float)(-localDirection.z * (double)targetTilt);
        float targetZRot = (float)(localDirection.x * (double)targetTilt);
        entity.setXRot(VehicleEngineUtils.lerpAngle(entity.getXRot(), -targetXRot, tiltSmoothingFactor));
        entity.setZRot(VehicleEngineUtils.lerpAngle(entity.getRoll(), -targetZRot, tiltSmoothingFactor));
    }

    public static Matrix4d getWheelsTransform(VehicleEntity vehicle, float partialTicks) {
        Matrix4d transform = new Matrix4d();
        transform.translate((double)((float)Mth.lerp((double)partialTicks, (double)vehicle.xo, (double)vehicle.getX())), (double)((float)Mth.lerp((double)partialTicks, (double)vehicle.yo, (double)vehicle.getY())), (double)((float)Mth.lerp((double)partialTicks, (double)vehicle.zo, (double)vehicle.getZ())));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)vehicle.yRotO, (float)vehicle.getYRot())));
        return transform;
    }
}

