/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.event;

import com.atsuishio.superbwarfare.config.server.SpawnConfig;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.mob_guns.MobGunData;
import com.atsuishio.superbwarfare.entity.goal.GunShootGoal;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

@EventBusSubscriber(modid="superbwarfare")
public class EntityUseGunEventHandler {
    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        if (event.loadedFromDisk() || !((Boolean)SpawnConfig.SPAWN_MOB_WITH_GUNS.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        MobGunData data = MobGunData.from(mob);
        if (data == null || data.probability() <= 0.0 || data.probability() < entity.level().random.nextDouble()) {
            return;
        }
        GunData gunData = data.getGunData();
        if (gunData == null) {
            return;
        }
        mob.goalSelector.addGoal(data.goalWeight(), new GunShootGoal<Mob>(mob, data));
        if (data.backupAmmoCount() > 0) {
            gunData.virtualAmmo.set(data.backupAmmoCount());
        }
        if (data.spawnWithLoadedAmmo()) {
            gunData.reloadAmmo((Entity)mob);
        }
        gunData.save();
        mob.setItemInHand(InteractionHand.MAIN_HAND, gunData.stack);
    }
}

