/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModTags;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ArmorPlate
extends Item {
    public ArmorPlate() {
        super(new Item.Properties());
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (NBTTool.getTag(stack).getBoolean("Infinite")) {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.armor_plate.infinite").withStyle(ChatFormatting.GRAY));
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        ItemStack armor = playerIn.getItemBySlot(EquipmentSlot.CHEST);
        if (armor == ItemStack.EMPTY) {
            return InteractionResultHolder.fail((Object)stack);
        }
        int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
        if (armor.is(ModTags.Items.MILITARY_ARMOR)) {
            armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
        } else if (armor.is(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
            armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
        }
        if (NBTTool.getTag(armor).getDouble("ArmorPlate") < (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get())) {
            playerIn.startUsingItem(handIn);
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.BOW;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity) {
        if (!pLevel.isClientSide) {
            Player player;
            ItemStack armor = pLivingEntity.getItemBySlot(EquipmentSlot.CHEST);
            int armorLevel = (Integer)MiscConfig.DEFAULT_ARMOR_LEVEL.get();
            if (armor.is(ModTags.Items.MILITARY_ARMOR)) {
                armorLevel = (Integer)MiscConfig.MILITARY_ARMOR_LEVEL.get();
            } else if (armor.is(ModTags.Items.MILITARY_ARMOR_HEAVY)) {
                armorLevel = (Integer)MiscConfig.HEAVY_MILITARY_ARMOR_LEVEL.get();
            }
            CompoundTag tag = NBTTool.getTag(armor);
            tag.putDouble("ArmorPlate", Mth.clamp((double)(tag.getDouble("ArmorPlate") + (double)((Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get()).intValue()), (double)0.0, (double)(armorLevel * (Integer)MiscConfig.ARMOR_POINT_PER_LEVEL.get())));
            NBTTool.saveTag(armor, tag);
            if (pLivingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pLivingEntity;
                serverPlayer.level().playSound((Entity)null, serverPlayer.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_IRON.value(), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (pLivingEntity instanceof Player && !(player = (Player)pLivingEntity).isCreative() && !NBTTool.getTag(pStack).getBoolean("Infinite")) {
                pStack.shrink(1);
            }
        }
        return super.finishUsingItem(pStack, pLevel, pLivingEntity);
    }

    @ParametersAreNonnullByDefault
    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public static ItemStack getInfiniteInstance() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.ARMOR_PLATE.get());
        CompoundTag tag = NBTTool.getTag(stack);
        tag.putBoolean("Infinite", true);
        NBTTool.saveTag(stack, tag);
        return stack;
    }
}

