/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.DPSGeneratorEntity;
import com.atsuishio.superbwarfare.entity.TargetEntity;
import com.atsuishio.superbwarfare.entity.mixin.BeastEntityKiller;
import com.atsuishio.superbwarfare.init.ModDamageTypes;
import com.atsuishio.superbwarfare.init.ModEnumExtensions;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.CustomDamageProperty;
import com.atsuishio.superbwarfare.network.message.receive.ClientIndicatorMessage;
import com.atsuishio.superbwarfare.network.message.receive.LivingGunKillMessage;
import com.atsuishio.superbwarfare.tools.TraceTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Beast
extends SwordItem {
    public Beast() {
        super((Tier)Tiers.NETHERITE, new CustomDamageProperty(false).stacksTo(1).rarity(ModEnumExtensions.getLegendary()).setNoRepair());
    }

    @ParametersAreNonnullByDefault
    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Beast.beastKill((Entity)attacker, (Entity)target);
        return true;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return false;
    }

    public static void beastKill(@Nullable Entity attacker, @NotNull Entity target) {
        if (target.level().isClientSide) {
            return;
        }
        if (target instanceof TargetEntity) {
            target.hurt(ModDamageTypes.causeBeastDamage(target.level().registryAccess(), attacker, attacker), 114514.195f);
            return;
        }
        if (target instanceof DPSGeneratorEntity) {
            DPSGeneratorEntity generator = (DPSGeneratorEntity)target;
            generator.hurt(ModDamageTypes.causeBeastDamage(generator.level().registryAccess(), attacker, attacker), 114514.195f);
            generator.beastCharge();
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientIndicatorMessage(0, 5), (CustomPacketPayload[])new CustomPacketPayload[0]);
            Holder holder = Holder.direct((Object)((SoundEvent)ModSounds.INDICATION.get()));
            player.connection.send((Packet)new ClientboundSoundPacket(holder, SoundSource.PLAYERS, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.level().random.nextLong()));
            AABB box = target.getBoundingBox();
            ((ServerLevel)attacker.level()).sendParticles((ParticleOptions)ParticleTypes.DAMAGE_INDICATOR, target.getX(), target.getY() + 0.5, target.getZ(), 1000, box.getXsize() / 2.5, box.getYsize() / 3.0, box.getZsize() / 2.5, 0.0);
            if (((Boolean)MiscConfig.SEND_KILL_FEEDBACK.get()).booleanValue()) {
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new LivingGunKillMessage(player.getId(), target.getId(), false, ModDamageTypes.BEAST), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (target instanceof ServerPlayer) {
            ServerPlayer victim = (ServerPlayer)target;
            victim.setHealth(0.0f);
            victim.level().players().forEach(p -> p.sendSystemMessage((Component)Component.translatable((String)"death.attack.beast_gun", (Object[])new Object[]{victim.getDisplayName(), attacker != null ? attacker.getDisplayName() : ""})));
        } else {
            if (target instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)target;
                BeastEntityKiller.getInstance(living).sbw$kill();
                living.setHealth(0.0f);
            }
            target.level().broadcastEntityEvent(target, (byte)60);
            target.removalReason = Entity.RemovalReason.KILLED;
            target.getPassengers().forEach(Entity::stopRiding);
            target.stopRiding();
            target.levelCallback.onRemove(Entity.RemovalReason.KILLED);
            target.gameEvent((Holder)GameEvent.ENTITY_DIE);
        }
        target.level().playSound(target, new BlockPos((int)target.getX(), (int)target.getY(), (int)target.getZ()), (SoundEvent)ModSounds.OUCH.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        return super.getSweepHitBox(stack, player, target).inflate(3.0);
    }

    @ParametersAreNonnullByDefault
    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Entity target = TraceTool.findMeleeEntity((Entity)entity, 51.4);
        if (target != null) {
            Beast.beastKill((Entity)entity, target);
        }
        return super.onEntitySwing(stack, entity, hand);
    }

    @ParametersAreNonnullByDefault
    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Beast.beastKill((Entity)player, entity);
        return super.onLeftClickEntity(stack, player, entity);
    }

    @ParametersAreNonnullByDefault
    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.beast").withColor(10840149));
    }
}

