/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.entity.projectile.C4Entity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.NBTTool;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class C4BombItem
extends Item {
    public static final String TAG_CONTROL = "Control";

    public C4BombItem() {
        super(new Item.Properties());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            boolean flag = NBTTool.getTag(stack).getBoolean(TAG_CONTROL);
            C4Entity entity = new C4Entity((LivingEntity)player, level, flag);
            entity.setPos(player.getX() + 0.25 * player.getLookAngle().x, player.getEyeY() - (double)0.2f + 0.25 * player.getLookAngle().y, player.getZ() + 0.25 * player.getLookAngle().z);
            entity.setDeltaMovement(0.5 * player.getLookAngle().x, 0.5 * player.getLookAngle().y, 0.5 * player.getLookAngle().z);
            entity.setOwnerUUID(player.getUUID());
            level.addFreshEntity((Entity)entity);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.level().playSound(null, serverPlayer.getOnPos(), (SoundEvent)ModSounds.C4_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        player.getCooldowns().addCooldown((Item)this, 20);
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (NBTTool.getTag(stack).getBoolean(TAG_CONTROL)) {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.c4_bomb.control").withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.c4_bomb.time").withStyle(ChatFormatting.GRAY));
        }
    }

    public static ItemStack makeInstance() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.C4_BOMB.get());
        CompoundTag tag = NBTTool.getTag(stack);
        tag.putBoolean(TAG_CONTROL, true);
        NBTTool.saveTag(stack, tag);
        return stack;
    }

    public int getBurnTime(@NotNull ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        return 20000;
    }

    public static class C4DispenseItemBehavior
    extends DefaultDispenseItemBehavior {
        @ParametersAreNonnullByDefault
        @NotNull
        protected ItemStack execute(BlockSource blockSource, ItemStack stack) {
            ServerLevel level = blockSource.level();
            Position position = DispenserBlock.getDispensePosition((BlockSource)blockSource);
            Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
            C4Entity entity = new C4Entity((EntityType<C4Entity>)((EntityType)ModEntities.C4.get()), (Level)level);
            entity.setPos(position.x(), position.y(), position.z());
            int pX = direction.getStepX();
            float pY = (float)direction.getStepY() + 0.1f;
            int pZ = direction.getStepZ();
            Vec3 vec3 = new Vec3((double)pX, (double)pY, (double)pZ).normalize().scale(0.05);
            entity.setDeltaMovement(vec3);
            double d0 = vec3.horizontalDistance();
            entity.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
            entity.setXRot((float)(Mth.atan2((double)vec3.y, (double)d0) * 57.2957763671875));
            entity.yRotO = entity.getYRot();
            entity.xRotO = entity.getXRot();
            level.addFreshEntity((Entity)entity);
            stack.shrink(1);
            return stack;
        }
    }
}

