/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item;

import com.atsuishio.superbwarfare.block.VehicleAssemblingTableBlock;
import com.atsuishio.superbwarfare.block.property.BlockPart;
import com.atsuishio.superbwarfare.client.renderer.item.VehicleAssemblingTableBlockItemRenderer;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModItems;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class VehicleAssemblingTableBlockItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public VehicleAssemblingTableBlockItem() {
        super((Block)ModBlocks.VEHICLE_ASSEMBLING_TABLE.get(), new Item.Properties());
    }

    @Nullable
    public static BlockPos findInitialPos(@NotNull BlockPlaceContext context, BlockPos currentPos, Direction facing) {
        BlockPart availablePart = null;
        for (BlockPart part : BlockPart.values()) {
            BlockPos placePos = part.relativeNegative(currentPos, facing);
            if (!VehicleAssemblingTableBlockItem.canPlace(context, placePos, facing)) continue;
            availablePart = part;
            break;
        }
        if (availablePart == null) {
            return null;
        }
        return availablePart.relativeNegative(currentPos, facing);
    }

    protected boolean canPlace(@NotNull BlockPlaceContext context, @NotNull BlockState state) {
        Direction facing = (Direction)state.getValue((Property)VehicleAssemblingTableBlock.FACING);
        BlockPos initialPos = VehicleAssemblingTableBlockItem.findInitialPos(context, context.getClickedPos(), facing);
        if (initialPos == null) {
            return false;
        }
        Player player = context.getPlayer();
        CollisionContext collisionContext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        for (BlockPart blockPart : BlockPart.values()) {
            BlockPos blockPos = blockPart.relative(initialPos, facing);
            if (context.getLevel().isUnobstructed(state, blockPos, collisionContext)) continue;
            return false;
        }
        return super.canPlace(context, state);
    }

    public static boolean canPlace(@NotNull BlockPlaceContext context, BlockPos pos, Direction direction) {
        for (BlockPart part : BlockPart.values()) {
            BlockPos detectPos = part.relative(pos, direction);
            if (context.getLevel().getBlockState(detectPos).canBeReplaced(context)) continue;
            return false;
        }
        return true;
    }

    public static boolean canPlace(@NotNull Level level, BlockPos pos, Direction direction, BlockPos skipPos) {
        for (BlockPart part : BlockPart.values()) {
            BlockPos detectPos = part.relative(pos, direction);
            if (detectPos.equals((Object)skipPos) || level.getBlockState(detectPos).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @SubscribeEvent
    private static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new VehicleAssemblingTableBlockItemRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Holder[]{ModItems.VEHICLE_ASSEMBLING_TABLE});
    }
}

