/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.armor;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.init.ModAttributes;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class BulletResistantArmor
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float bulletResistance = 0.1f;

    public BulletResistantArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    public BulletResistantArmor(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, float bulletResistance) {
        super(material, type, properties);
        this.bulletResistance = bulletResistance;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract Supplier<GeoArmorRenderer<? extends Item>> getRenderer();

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<? extends Item> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(T livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = BulletResistantArmor.this.getRenderer().get();
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
    }

    @NotNull
    public ItemAttributeModifiers getDefaultAttributeModifiers(@NotNull ItemStack stack) {
        ItemAttributeModifiers modifiers = super.getDefaultAttributeModifiers(stack);
        ArrayList<ItemAttributeModifiers.Entry> list = new ArrayList<ItemAttributeModifiers.Entry>(modifiers.modifiers());
        list.add(new ItemAttributeModifiers.Entry(ModAttributes.BULLET_RESISTANCE, new AttributeModifier(Mod.ATTRIBUTE_MODIFIER, (double)this.bulletResistance * Math.max(0.0, 1.0 - (double)stack.getDamageValue() / (double)stack.getMaxDamage()), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.bySlot((EquipmentSlot)this.type.getSlot())));
        return new ItemAttributeModifiers(list, true);
    }
}

