/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.ammo;

import com.atsuishio.superbwarfare.entity.projectile.MediumRocketEntity;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModSounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MediumRocketItem
extends Item
implements ProjectileItem {
    private final float damage;
    private final float radius;
    private final float explosionDamage;
    private final float fireProbability;
    private final int fireTime;
    public final MediumRocketEntity.Type type;
    private final int spreadAmount;

    public MediumRocketItem(float damage, float radius, float explosionDamage, float fireProbability, int fireTime, MediumRocketEntity.Type type, int spreadAmount) {
        super(new Item.Properties());
        this.damage = damage;
        this.radius = radius;
        this.explosionDamage = explosionDamage;
        this.fireProbability = fireProbability;
        this.fireTime = fireTime;
        this.type = type;
        this.spreadAmount = spreadAmount;
    }

    public MediumRocketEntity createProjectile(Level level, Position pos) {
        return new MediumRocketEntity((EntityType<? extends ThrowableItemProjectile>)((EntityType)ModEntities.MEDIUM_ROCKET.get()), pos.x(), pos.y(), pos.z(), level, this.damage, this.radius, this.explosionDamage, this.fireProbability, this.fireTime, this.type, this.spreadAmount, 15);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        return this.createProjectile(level, pos);
    }

    @NotNull
    public ProjectileItem.DispenseConfig createDispenseConfig() {
        return ProjectileItem.DispenseConfig.builder().power(6.0f).build();
    }

    public static class MediumRocketDispenseBehavior
    extends ProjectileDispenseBehavior {
        public MediumRocketDispenseBehavior(Item item) {
            super(item);
        }

        protected void playSound(BlockSource blockSource) {
            blockSource.level().playSound(null, blockSource.pos(), (SoundEvent)ModSounds.MEDIUM_ROCKET_FIRE.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
        }
    }
}

