/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.common.container;

import com.atsuishio.superbwarfare.api.event.RegisterContainersEvent;
import com.atsuishio.superbwarfare.client.renderer.item.ContainerBlockItemRenderer;
import com.atsuishio.superbwarfare.init.ModBlockEntities;
import com.atsuishio.superbwarfare.init.ModBlocks;
import com.atsuishio.superbwarfare.init.ModEntities;
import com.atsuishio.superbwarfare.init.ModItems;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

@EventBusSubscriber(modid="superbwarfare", bus=EventBusSubscriber.Bus.MOD)
public class ContainerBlockItem
extends BlockItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerContainers(RegisterContainersEvent event) {
        event.add(ModEntities.WHEEL_CHAIR);
        event.add((EntityType)ModEntities.TRUCK.get());
        event.add(ModEntities.TYPE_63);
        event.add(ModEntities.MK_42);
        event.add(ModEntities.MLE_1934);
        event.add(ModEntities.BL_132);
        event.add(ModEntities.HPJ_11);
        event.add(ModEntities.LASER_TOWER);
        event.add(ModEntities.WAVEFORCE_TOWER);
        event.add(ModEntities.ANNIHILATOR);
        event.add(ModEntities.SPEEDBOAT);
        event.add(ModEntities.LAV_150);
        event.add(ModEntities.BMP_2);
        event.add(ModEntities.PRISM_TANK);
        event.add(ModEntities.YX_100);
        event.add(ModEntities.PLZ_05);
        event.add(ModEntities.AH_6);
        event.add(ModEntities.MI_28);
        event.add(ModEntities.TOM_6);
        event.add(ModEntities.A_10A);
    }

    public ContainerBlockItem() {
        super((Block)ModBlocks.CONTAINER.get(), new Item.Properties().stacksTo(1).fireResistant());
    }

    @ParametersAreNonnullByDefault
    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return super.canBeHurtBy(stack, source) && !source.is(DamageTypeTags.IS_EXPLOSION) && !source.is(DamageTypes.CACTUS);
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        return InteractionResult.PASS;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult playerPOVHitResult = ContainerBlockItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (playerPOVHitResult.getType() == HitResult.Type.MISS) {
            return super.use(level, player, hand);
        }
        BlockHitResult blockHitResult = playerPOVHitResult.withPosition(playerPOVHitResult.getBlockPos().above());
        InteractionResult interactionresult = super.useOn(new UseOnContext(player, hand, blockHitResult));
        return new InteractionResultHolder(interactionresult, (Object)player.getItemInHand(hand));
    }

    @NotNull
    public InteractionResult place(BlockPlaceContext pContext) {
        CustomData tag;
        ItemStack stack = pContext.getItemInHand();
        Player player = pContext.getPlayer();
        InteractionResult res = super.place(pContext);
        if (player != null && (tag = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA)) != null && tag.copyTag().get("Entity") != null) {
            if (player.level().isClientSide && res == InteractionResult.SUCCESS) {
                player.getInventory().removeItem(stack);
            }
            if (!player.level().isClientSide && res == InteractionResult.CONSUME) {
                player.getInventory().removeItem(stack);
            }
        }
        return res;
    }

    private PlayState predicate(AnimationState<ContainerBlockItem> event) {
        return PlayState.CONTINUE;
    }

    @SubscribeEvent
    private static void registerArmorExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            private final BlockEntityWithoutLevelRenderer renderer = new ContainerBlockItemRenderer();

            @NotNull
            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return this.renderer;
            }
        }, new Holder[]{ModItems.CONTAINER});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static ItemStack createInstance(Entity entity) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.CONTAINER.get());
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag tag = data != null ? data.copyTag() : new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        String encodedId = entity.getEncodeId();
        if (encodedId != null) {
            entityTag.putString("id", encodedId);
        }
        entity.saveWithoutId(entityTag);
        tag.put("Entity", (Tag)entityTag);
        tag.putString("EntityType", EntityType.getKey((EntityType)entity.getType()).toString());
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.CONTAINER.get()), (CompoundTag)tag);
        return stack;
    }

    public static ItemStack createInstance(EntityType<?> entityType) {
        ItemStack stack = new ItemStack((ItemLike)ModBlocks.CONTAINER.get());
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag tag = data != null ? data.copyTag() : new CompoundTag();
        tag.putString("EntityType", EntityType.getKey(entityType).toString());
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)ModBlockEntities.CONTAINER.get()), (CompoundTag)tag);
        return stack;
    }
}

