/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.sniper;

import com.atsuishio.superbwarfare.client.TooltipTool;
import com.atsuishio.superbwarfare.client.renderer.gun.Ql1031ItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModEnumExtensions;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.GunsTool;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class Ql1031Item
extends GunGeoItem {
    public Ql1031Item() {
        super(new Item.Properties().rarity(ModEnumExtensions.getLegendary()));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return Ql1031ItemRenderer::new;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.empty());
        tooltipComponents.add((Component)Component.translatable((String)"des.superbwarfare.ql_1031_1").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        TooltipTool.addHideText(tooltipComponents, (Component)Component.empty());
        TooltipTool.addHideText(tooltipComponents, (Component)Component.translatable((String)"des.superbwarfare.trachelium_3").withStyle(ChatFormatting.WHITE));
        TooltipTool.addHideText(tooltipComponents, (Component)Component.translatable((String)"des.superbwarfare.ql_1031_2").withStyle(Style.EMPTY.withColor(16772327)));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState editPredicate(AnimationState<Ql1031Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return PlayState.STOP;
        }
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
        }
        if (ClientEventHandler.isEditing) {
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.ql_1031.edit"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private PlayState chargePredicate(AnimationState<Ql1031Item> event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return PlayState.STOP;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof GunItem)) {
            return PlayState.STOP;
        }
        GunItem gunItem = (GunItem)item;
        if (event.getData(DataTickets.ITEM_RENDER_PERSPECTIVE) != ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
        }
        GunData data = GunData.from(stack);
        if (ClientEventHandler.holdingFireKey && gunItem.canShoot(data, (Entity)player) && data.selectedFireModeInfo().name.equals("Hold")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.charge"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ql_1031.idle"));
    }

    @Override
    public void afterShoot(@NotNull ShootParameters parameters) {
        super.afterShoot(parameters);
        GunData data = parameters.data();
        ServerLevel level = parameters.level();
        Vec3 shootPosition = parameters.shootPosition();
        Vec3 shootDirection = parameters.shootDirection();
        if (data.selectedFireModeInfo().name.equals("Hold")) {
            for (int i = 0; i < 40; i += 2) {
                Vec3 pos = shootPosition.add(shootDirection.normalize().scale(1.0 + 0.5 * (double)i + 0.05 * (double)i * (double)i));
                ParticleTool.sendParticle(level, ParticleTypes.CHERRY_LEAVES, pos.x, pos.y - 0.12, pos.z, 1, 0.04, 0.04, 0.04, 1.0, false);
            }
        }
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        AnimationController editController = new AnimationController((GeoAnimatable)this, "editController", 1, this::editPredicate);
        AnimationController chargeController = new AnimationController((GeoAnimatable)this, "chargeController", 1, this::chargePredicate);
        data.add(editController);
        data.add(chargeController);
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.getInventory().items) {
                if (!(cell.getItem() instanceof BatteryItem)) continue;
                IEnergyStorage stackCap = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
                int stackMaxEnergy = stackCap != null ? stackCap.getMaxEnergyStored() : 0;
                int stackEnergy = stackCap != null ? stackCap.getEnergyStored() : 0;
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                int cellEnergy = cellStorage != null ? cellStorage.getEnergyStored() : 0;
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0 && stackCap != null) {
                    stackCap.receiveEnergy(stackEnergyNeed, false);
                }
                if (cellStorage == null) continue;
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @Override
    public boolean canSwitchScope(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 2;
    }

    @Override
    public double getCustomZoom(GunData data) {
        int scopeType = data.attachment.get(AttachmentType.SCOPE);
        return switch (scopeType) {
            case 2 -> {
                if (data.tag.getBoolean("ScopeAlt")) {
                    yield 0.0;
                }
                yield 2.75;
            }
            case 3 -> GunsTool.getGunDoubleTag(data.tag, "CustomZoom");
            default -> 0.0;
        };
    }

    @Override
    public boolean canAdjustZoom(GunData data) {
        return data.attachment.get(AttachmentType.SCOPE) == 3;
    }

    @Override
    public boolean hasBulletInBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomBarrel(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomGrip(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomScope(GunData data) {
        return true;
    }

    @Override
    public boolean hasCustomStock(GunData data) {
        return true;
    }

    @Override
    public boolean canEditAttachments(GunData data) {
        return true;
    }
}

