/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.item.gun.special;

import com.atsuishio.superbwarfare.client.renderer.gun.TaserItemRenderer;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.ShootParameters;
import com.atsuishio.superbwarfare.init.ModPerks;
import com.atsuishio.superbwarfare.item.BatteryItem;
import com.atsuishio.superbwarfare.item.gun.GunGeoItem;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class TaserItem
extends GunGeoItem {
    public TaserItem() {
        super(new Item.Properties().rarity(Rarity.COMMON));
    }

    @Override
    public Supplier<? extends GeoItemRenderer<? extends Item>> getRenderer() {
        return TaserItemRenderer::new;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (ItemStack cell : player.getInventory().items) {
                IEnergyStorage stackStorage;
                if (!(cell.getItem() instanceof BatteryItem) || (stackStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM)) == null) continue;
                int stackMaxEnergy = stackStorage.getMaxEnergyStored();
                int stackEnergy = stackStorage.getEnergyStored();
                IEnergyStorage cellStorage = (IEnergyStorage)cell.getCapability(Capabilities.EnergyStorage.ITEM);
                if (cellStorage == null) continue;
                int cellEnergy = cellStorage.getEnergyStored();
                int stackEnergyNeed = Math.min(cellEnergy, stackMaxEnergy - stackEnergy);
                if (cellEnergy > 0) {
                    stackStorage.receiveEnergy(stackEnergyNeed, false);
                }
                cellStorage.extractEnergy(stackEnergyNeed, false);
            }
        }
    }

    @Override
    public void afterShoot(@NotNull ShootParameters parameters) {
        super.afterShoot(parameters);
        GunData data = parameters.data();
        ItemStack stack = data.stack;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        IEnergyStorage energyStorage = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (energyStorage != null) {
            energyStorage.extractEnergy(400 + 100 * perkLevel, false);
        }
    }

    @Override
    public boolean canShoot(GunData data, @Nullable Entity shooter) {
        boolean hasEnoughEnergy;
        short perkLevel = data.perk.getLevel(ModPerks.VOLT_OVERLOAD);
        IEnergyStorage energyStorage = (IEnergyStorage)data.stack.getCapability(Capabilities.EnergyStorage.ITEM);
        boolean bl = hasEnoughEnergy = energyStorage != null && energyStorage.getEnergyStored() >= 400 + 100 * perkLevel;
        if (!hasEnoughEnergy) {
            return false;
        }
        return super.canShoot(data, shooter);
    }
}

