/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.menu;

import com.atsuishio.superbwarfare.init.ModMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SuperbItemInterfaceMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    private final Container container;

    public SuperbItemInterfaceMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(5));
    }

    public SuperbItemInterfaceMenu(int containerId, Inventory playerInventory, Container container) {
        super(ModMenuTypes.SUPERB_ITEM_INTERFACE_MENU.get(), containerId);
        this.container = container;
        SuperbItemInterfaceMenu.checkContainerSize((Container)container, (int)5);
        container.startOpen(playerInventory.player);
        for (int j = 0; j < 5; ++j) {
            this.addSlot(new Slot(container, j, 44 + j * 18, 20));
        }
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + l * 9 + 9, 8 + k * 18, l * 18 + 51));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)playerInventory, i1, 8 + i1 * 18, 109));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            stack = slotItem.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(slotItem, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(slotItem, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }
}

