/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.client.ICustomCamera;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Matrix4d;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4d;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class CameraMixin
implements ICustomCamera {
    @Shadow
    @Final
    private Quaternionf rotation;
    @Shadow
    @Final
    private Vector3f forwards;
    @Shadow
    @Final
    private Vector3f up;
    @Shadow
    @Final
    private Vector3f left;
    @Shadow
    private float xRot;
    @Shadow
    private float yRot;

    @Shadow
    @Deprecated
    protected abstract void setRotation(float var1, float var2);

    @Shadow
    protected abstract void setPosition(double var1, double var3, double var5);

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/Camera;setRotation(FFF)V", ordinal=0)}, method={"setup"}, cancellable=true)
    private void onSetup(BlockGetter level, Entity entity, boolean detached, boolean thirdPersonReverse, float partialTicks, CallbackInfo info) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            DroneEntity drone = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
            if (drone != null) {
                boolean firstPerson;
                boolean bl = firstPerson = Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON || Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK;
                if (firstPerson) {
                    Matrix4d transform = CameraMixin.superbWarfare$getDroneTransform(drone, partialTicks);
                    double x0 = 0.0;
                    double y0 = 0.075;
                    double z0 = 0.18;
                    Vector4d worldPosition = CameraMixin.superbWarfare$transformPosition(transform, x0, y0, z0);
                    this.setRotation(drone.getYaw(partialTicks), drone.getPitch(partialTicks));
                    this.setPosition(worldPosition.x, worldPosition.y, worldPosition.z);
                    info.cancel();
                } else {
                    Vec3 position;
                    Vec2 rotation = drone.getCameraRotation(partialTicks, (Player)player, false, false);
                    if (rotation != null) {
                        this.setRotation(rotation.x, rotation.y);
                    }
                    if ((position = drone.getCameraPosition(partialTicks, (Player)player, false, false)) != null) {
                        this.setPosition(position.x, position.y, position.z);
                    }
                    if (rotation != null || position != null) {
                        info.cancel();
                    }
                }
            }
            return;
        }
        Entity firstPerson = player.getVehicle();
        if (firstPerson instanceof VehicleEntity) {
            Vec3 position;
            VehicleEntity vehicle = (VehicleEntity)firstPerson;
            Vec2 rotation = vehicle.getCameraRotation(partialTicks, (Player)player, ClientEventHandler.zoomVehicle, Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON);
            if (rotation != null) {
                this.setRotation(rotation.x, rotation.y);
            }
            if ((position = vehicle.getCameraPosition(partialTicks, (Player)player, ClientEventHandler.zoomVehicle, Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON)) != null) {
                this.setPosition(position.x, position.y, position.z);
            }
            if (rotation != null || position != null) {
                info.cancel();
            }
        }
    }

    @Unique
    private static Matrix4d superbWarfare$getDroneTransform(DroneEntity vehicle, float ticks) {
        Matrix4d transform = new Matrix4d();
        transform.translate(Mth.lerp((double)ticks, (double)vehicle.xo, (double)vehicle.getX()), Mth.lerp((double)ticks, (double)vehicle.yo, (double)vehicle.getY()), Mth.lerp((double)ticks, (double)vehicle.zo, (double)vehicle.getZ()));
        transform.rotate((Quaternionfc)Axis.YP.rotationDegrees(-vehicle.getYaw(ticks)));
        transform.rotate((Quaternionfc)Axis.XP.rotationDegrees(vehicle.getBodyPitch(ticks)));
        transform.rotate((Quaternionfc)Axis.ZP.rotationDegrees(vehicle.getRoll(ticks)));
        return transform;
    }

    @Unique
    private static Vector4d superbWarfare$transformPosition(Matrix4d transform, double x, double y, double z) {
        return transform.transform(new Vector4d(x, y, z, 1.0));
    }

    @Inject(method={"setup"}, at={@At(value="TAIL")})
    public void superbWarfare$setup(BlockGetter area, Entity entity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        Entity entity2;
        Player player;
        if (Minecraft.getInstance().options.getCameraType() == CameraType.THIRD_PERSON_BACK && entity instanceof Player && (player = (Player)entity).getMainHandItem().getItem() instanceof GunItem && Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos) > 0.0) {
            this.move(-this.getMaxZoom((float)(-2.9 * Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos))), 0.0f, (float)(-ClientEventHandler.cameraLocation * Math.max((double)ClientEventHandler.bowPullPos, (double)ClientEventHandler.zoomPos)));
            return;
        }
        if (!thirdPerson || !((entity2 = entity.getVehicle()) instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity2;
        Vec3 cameraPosition = vehicle.getThirdPersonCameraPosition();
        this.move(-this.getMaxZoom((float)cameraPosition.x()), (float)cameraPosition.y(), (float)cameraPosition.z());
    }

    @Shadow
    protected abstract void move(float var1, float var2, float var3);

    @Shadow
    protected abstract float getMaxZoom(float var1);

    @Override
    public Quaternionf superbwarfare$getRotation() {
        return this.rotation;
    }
}

