/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModKeyMappings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientPacketListener.class})
public abstract class ClientPacketListenerMixin {
    @Shadow
    private ClientLevel level;

    @Inject(method={"handleSetEntityPassengersPacket(Lnet/minecraft/network/protocol/game/ClientboundSetPassengersPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void vehicleEntityUpdate(ClientboundSetPassengersPacket pPacket, CallbackInfo ci) {
        Minecraft minecraft = Minecraft.getInstance();
        PacketUtils.ensureRunningOnSameThread((Packet)pPacket, (PacketListener)((ClientPacketListener)this), (BlockableEventLoop)minecraft);
        Entity entity = this.level.getEntity(pPacket.getVehicle());
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        ci.cancel();
        LocalPlayer player = minecraft.player;
        assert (player != null);
        boolean hasIndirectPassenger = entity.hasIndirectPassenger((Entity)player);
        entity.ejectPassengers();
        int[] passengers = pPacket.getPassengers();
        vehicle.entityIndexOverride = e -> {
            for (int i = 0; i < passengers.length; ++i) {
                if (passengers[i] != e.getId()) continue;
                return i;
            }
            return -1;
        };
        for (int i : passengers) {
            Entity passenger;
            if (i == -1 || (passenger = this.level.getEntity(i)) == null) continue;
            passenger.startRiding(entity, true);
            if (passenger != player && !hasIndirectPassenger) continue;
            MutableComponent component = Component.translatable((String)"mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.getTranslatedKeyMessage()});
            if (vehicle.allowEjection(vehicle.getSeatIndex(passenger))) {
                component = Component.translatable((String)"tips.superbwarfare.mount.onboard", (Object[])new Object[]{ModKeyMappings.DISMOUNT.getTranslatedKeyMessage()});
            }
            Minecraft.getInstance().gui.setOverlayMessage((Component)component, false);
            Minecraft.getInstance().getNarrator().sayNow((Component)component);
        }
        vehicle.entityIndexOverride = null;
    }
}

