/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.data.vehicle.VehicleData;
import com.atsuishio.superbwarfare.data.vehicle.subdata.SeatInfo;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public class LivingEntityRendererMixin<T extends LivingEntity> {
    @Inject(method={"setupRotations"}, at={@At(value="TAIL")})
    public void render(T entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale, CallbackInfo ci) {
        Entity entity2;
        if (entity.getRootVehicle() != entity && (entity2 = entity.getRootVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity2;
            float a = Mth.wrapDegrees((float)(Mth.lerp((float)partialTick, (float)((LivingEntity)entity).yBodyRotO, (float)((LivingEntity)entity).yBodyRot) - Mth.lerp((float)partialTick, (float)vehicle.yRotO, (float)vehicle.getYRot())));
            List<SeatInfo> seats = VehicleData.compute(vehicle).seats();
            int index = vehicle.getSeatIndex((Entity)entity);
            if (index < 0 || index >= seats.size()) {
                return;
            }
            SeatInfo seat = seats.get(index);
            if (seat.transform.equals("VehicleFlat")) {
                return;
            }
            if (((LivingEntity)entity).yBodyRot == vehicle.getYRot()) {
                a = 0.0f;
            }
            float r = (Mth.abs((float)a) - 90.0f) / 90.0f;
            float r2 = Mth.abs((float)a) <= 90.0f ? a / 90.0f : (a < 0.0f ? -(180.0f + a) / 90.0f : (180.0f - a) / 90.0f);
            poseStack.mulPose(Axis.XP.rotationDegrees(r * vehicle.getViewXRot(partialTick) - r2 * vehicle.getRoll(partialTick)));
            poseStack.mulPose(Axis.ZP.rotationDegrees(r * vehicle.getRoll(partialTick) + r2 * vehicle.getViewXRot(partialTick)));
        }
    }
}

