/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.data.vehicle.subdata.VehicleType;
import com.atsuishio.superbwarfare.entity.vehicle.TowEntity;
import com.atsuishio.superbwarfare.entity.vehicle.Yx100Entity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.item.curio.ParachuteItem;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")})
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch, CallbackInfo ci) {
        if (pEntity instanceof Player) {
            Yx100Entity yx100Entity;
            VehicleEntity vehicle;
            Entity entity;
            Player player = (Player)pEntity;
            PlayerModel model = (PlayerModel)this;
            if (ParachuteItem.isParachuteOpen(pEntity)) {
                model.leftArm.xRot = (float)(-Math.PI);
                model.rightArm.xRot = (float)(-Math.PI);
                model.leftSleeve.xRot = (float)(-Math.PI);
                model.rightSleeve.xRot = (float)(-Math.PI);
                model.leftArm.yRot = -0.2617994f;
                model.rightArm.yRot = 0.2617994f;
                model.leftSleeve.yRot = -0.2617994f;
                model.rightSleeve.yRot = 0.2617994f;
                model.leftLeg.xRot = 0.0f;
                model.rightLeg.xRot = 0.0f;
                model.leftLeg.yRot = 0.0f;
                model.rightLeg.yRot = 0.0f;
                model.leftPants.xRot = 0.0f;
                model.rightPants.xRot = 0.0f;
                model.leftPants.yRot = 0.0f;
                model.rightPants.yRot = 0.0f;
                model.body.xRot = 0.0f;
                model.body.yRot = 0.0f;
                model.body.zRot = 0.0f;
            }
            if ((entity = player.getVehicle()) instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).banHand((LivingEntity)player) && (vehicle.getVehicleType() == VehicleType.AIRPLANE || vehicle.getVehicleType() == VehicleType.HELICOPTER)) {
                model.head.xRot = 0.0f;
                model.head.yRot = 0.0f;
                model.head.zRot = 0.0f;
                model.hat.xRot = 0.0f;
                model.hat.yRot = 0.0f;
                model.hat.zRot = 0.0f;
                model.rightArm.xRot = -0.9599311f;
                model.rightSleeve.xRot = -0.9599311f;
                model.rightArm.yRot = -0.2617994f;
                model.rightSleeve.yRot = -0.2617994f;
                model.rightArm.zRot = -0.5235988f;
                model.rightSleeve.zRot = -0.5235988f;
            }
            if (player.getVehicle() instanceof TowEntity) {
                model.head.xRot = 0.0f;
                model.hat.xRot = 0.0f;
                model.head.y = 0.0f;
                model.hat.y = 0.0f;
                model.head.z = -4.0f;
                model.hat.z = -4.0f;
                model.leftArm.yRot = 0.7853982f;
                model.leftArm.xRot = -2.0071287f;
                model.leftSleeve.yRot = 0.7853982f;
                model.leftSleeve.xRot = -2.0071287f;
                model.rightArm.yRot = 0.43633232f;
                model.rightArm.xRot = -2.0071287f;
                model.rightSleeve.yRot = 0.43633232f;
                model.rightSleeve.xRot = -2.0071287f;
                model.leftLeg.xRot = 0.0f;
                model.leftPants.xRot = 0.0f;
                model.leftLeg.yRot = 0.0f;
                model.leftPants.yRot = 0.0f;
                model.leftLeg.zRot = 0.0f;
                model.leftPants.zRot = 0.0f;
                model.leftLeg.z = -6.0f;
                model.leftPants.z = -6.0f;
                model.leftLeg.y = 5.4f;
                model.leftPants.y = 5.4f;
                model.rightLeg.xRot = 1.4835298f;
                model.rightPants.xRot = 1.4835298f;
                model.rightLeg.yRot = 0.0f;
                model.rightPants.yRot = 0.0f;
                model.rightLeg.zRot = 0.0f;
                model.rightPants.zRot = 0.0f;
                model.rightLeg.z = -4.0f;
                model.rightPants.z = -4.0f;
                model.rightLeg.y = 14.0f;
                model.rightPants.y = 14.0f;
                model.body.xRot = 0.34906584f;
                model.body.z = -5.0f;
                model.leftArm.z = -5.0f;
                model.leftSleeve.z = -5.0f;
                model.rightArm.z = -5.0f;
                model.rightSleeve.z = -5.0f;
            }
            if ((entity = player.getVehicle()) instanceof Yx100Entity && ((yx100Entity = (Yx100Entity)entity).getNthEntity(3) == player || yx100Entity.getNthEntity(4) == player)) {
                model.leftArm.xRot = -1.9634954f;
                model.leftSleeve.xRot = -1.9634954f;
                model.rightArm.xRot = -1.9634954f;
                model.rightSleeve.xRot = -1.9634954f;
            }
            if (player.getMainHandItem().getItem() instanceof GunItem && player.getPose() == Pose.SWIMMING && !player.isSwimming()) {
                model.hat.xRot = (player.getViewXRot(1.0f) - 90.0f) * ((float)Math.PI / 180);
                model.head.xRot = (player.getViewXRot(1.0f) - 90.0f) * ((float)Math.PI / 180);
                model.hat.yRot = 0.0f;
                model.head.yRot = 0.0f;
                model.leftArm.xRot = (-180.0f + player.getViewXRot(1.0f)) * ((float)Math.PI / 180);
                model.rightArm.xRot = (-180.0f + player.getViewXRot(1.0f)) * ((float)Math.PI / 180);
                model.leftSleeve.xRot = (-180.0f + player.getViewXRot(1.0f)) * ((float)Math.PI / 180);
                model.rightSleeve.xRot = (-180.0f + player.getViewXRot(1.0f)) * ((float)Math.PI / 180);
                model.leftArm.yRot = 0.0f;
                model.rightArm.yRot = 0.0f;
                model.leftSleeve.yRot = 0.0f;
                model.rightSleeve.yRot = 0.0f;
                model.leftArm.zRot = -0.5235988f;
                model.rightArm.zRot = 0.0f;
                model.leftSleeve.zRot = -0.5235988f;
                model.rightSleeve.zRot = 0.0f;
                model.rightArm.x = -3.0f;
                model.rightSleeve.x = -3.0f;
                model.leftArm.x = 3.0f;
                model.leftSleeve.x = 3.0f;
            }
        }
    }
}

