/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.mixins;

import com.atsuishio.superbwarfare.entity.OBBEntity;
import com.atsuishio.superbwarfare.entity.mixin.OBBHitter;
import com.atsuishio.superbwarfare.init.ModParticleTypes;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.OBB;
import com.atsuishio.superbwarfare.tools.ParticleTool;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ProjectileUtil.class})
public class ProjectileUtilMixin {
    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;F)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Level pLevel, Entity pProjectile, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, float pInflationAmount, CallbackInfoReturnable<EntityHitResult> cir) {
        for (Entity entity : pLevel.getEntities(pProjectile, pBoundingBox.inflate(8.0), pFilter)) {
            Projectile projectile;
            OBBEntity obbEntity;
            Vector3d startVec = OBB.vec3ToVector3d(pStartVec);
            if (!(entity instanceof OBBEntity) || (obbEntity = (OBBEntity)entity).enableAABB() || pProjectile instanceof Projectile && ((projectile = (Projectile)pProjectile).getOwner() == entity || entity.getPassengers().contains(projectile.getOwner()))) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                Vector3d vec;
                double d1;
                obb = obb.inflate(entity.getPickRadius() * 2.0f);
                Optional<Vector3d> optional = obb.clip(OBB.vec3ToVector3d(pStartVec), OBB.vec3ToVector3d(pEndVec));
                double pDistance = pStartVec.distanceToSqr(pEndVec);
                if (obb.contains(pStartVec)) {
                    if (!(pDistance >= 0.0)) continue;
                    EntityHitResult hitResult = new EntityHitResult(entity, OBB.vector3dToVec3(optional.orElse(startVec)));
                    OBBHitter acc = OBBHitter.getInstance(pProjectile);
                    acc.sbw$setCurrentHitPart(obb.part());
                    cir.setReturnValue((Object)hitResult);
                    if (pLevel instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)pLevel;
                        if (pProjectile.getDeltaMovement().lengthSqr() > 0.01 && pProjectile instanceof Projectile) {
                            Vec3 hitPos = hitResult.getLocation();
                            pLevel.playSound(null, BlockPos.containing((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.2, false);
                            ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.01, false);
                        }
                    }
                    return;
                }
                if (!optional.isPresent() || !((d1 = pStartVec.distanceToSqr(OBB.vector3dToVec3(vec = new Vector3d((Vector3dc)optional.get())))) < pDistance) && pDistance != 0.0) continue;
                EntityHitResult hitResult = new EntityHitResult(entity, OBB.vector3dToVec3(vec));
                OBBHitter acc = OBBHitter.getInstance(pProjectile);
                acc.sbw$setCurrentHitPart(obb.part());
                cir.setReturnValue((Object)hitResult);
                if (pLevel instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    if (pProjectile.getDeltaMovement().lengthSqr() > 0.01 && pProjectile instanceof Projectile) {
                        Vec3 hitPos = hitResult.getLocation();
                        pLevel.playSound(null, BlockPos.containing((Position)hitPos), (SoundEvent)ModSounds.HIT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        ParticleTool.sendParticle(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE_STAR.get(), hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.2, false);
                        ParticleTool.sendParticle(serverLevel, ParticleTypes.SMOKE, hitPos.x, hitPos.y, hitPos.z, 2, 0.0, 0.0, 0.0, 0.01, false);
                    }
                }
                return;
            }
        }
    }

    @Inject(method={"getEntityHitResult(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;D)Lnet/minecraft/world/phys/EntityHitResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEntityHitResult(Entity pShooter, Vec3 pStartVec, Vec3 pEndVec, AABB pBoundingBox, Predicate<Entity> pFilter, double pDistance, CallbackInfoReturnable<EntityHitResult> cir) {
        Level level = pShooter.level();
        List entities = level.getEntities(pShooter, pBoundingBox.inflate(8.0), pFilter);
        Vector3d startVec = OBB.vec3ToVector3d(pStartVec);
        for (Entity entity : entities) {
            OBBEntity obbEntity;
            if (!(entity instanceof OBBEntity) || (obbEntity = (OBBEntity)entity).enableAABB() || entity.getPassengers().contains(pShooter)) continue;
            List<OBB> obbList = obbEntity.getOBBs();
            for (OBB obb : obbList) {
                Vector3d vec;
                double d1;
                obb = obb.inflate(entity.getPickRadius() * 2.0f);
                Optional<Vector3d> optional = obb.clip(OBB.vec3ToVector3d(pStartVec), OBB.vec3ToVector3d(pEndVec));
                if (obb.contains(pStartVec)) {
                    if (!(pDistance >= 0.0)) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(optional.orElse(startVec))));
                    return;
                }
                if (!optional.isPresent() || !((d1 = pStartVec.distanceToSqr(OBB.vector3dToVec3(vec = new Vector3d((Vector3dc)optional.get())))) < pDistance) && pDistance != 0.0) continue;
                if (entity.getRootVehicle() == pShooter.getRootVehicle() && !entity.canRiderInteract()) {
                    if (pDistance != 0.0) continue;
                    cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(vec)));
                    return;
                }
                cir.setReturnValue((Object)new EntityHitResult(entity, OBB.vector3dToVec3(vec)));
                return;
            }
        }
    }
}

