/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.tools.BufferSerializer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record GunsDataMessage(List<DefaultGunData> data) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<GunsDataMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("set_guns_data"));
    public static final StreamCodec<FriendlyByteBuf, GunsDataMessage> STREAM_CODEC = StreamCodec.ofMember((obj, buf) -> {
        buf.writeVarInt(obj.data.size());
        for (DefaultGunData data : obj.data) {
            buf.writeBytes(BufferSerializer.serialize(data).copy());
        }
    }, buf -> {
        int size = buf.readVarInt();
        ArrayList<DefaultGunData> list = new ArrayList<DefaultGunData>();
        for (int i = 0; i < size; ++i) {
            list.add(BufferSerializer.deserialize(buf, new DefaultGunData()));
        }
        return new GunsDataMessage(list);
    });

    public static GunsDataMessage create() {
        return new GunsDataMessage(CustomData.GUN_DATA.values().stream().toList());
    }

    public static void handler(GunsDataMessage message, IPayloadContext context) {
        CustomData.GUN_DATA.clear();
        for (DefaultGunData entry : message.data) {
            if (CustomData.GUN_DATA.containsKey(entry.id)) continue;
            CustomData.GUN_DATA.put(entry.id, entry);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

