/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.receive;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.event.ClientEventHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ShakeClientMessage(double time, double radius, double amplitude, double x, double y, double z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShakeClientMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("shake_client"));
    public static final StreamCodec<ByteBuf, ShakeClientMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::time, (StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::radius, (StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::amplitude, (StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::x, (StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::y, (StreamCodec)ByteBufCodecs.DOUBLE, ShakeClientMessage::z, ShakeClientMessage::new);

    public static void handler(ShakeClientMessage message, IPayloadContext context) {
        ClientEventHandler.handleShakeClient(message.time, message.radius, message.amplitude, message.x, message.y, message.z);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void sendToNearbyPlayers(Level level, double x, double y, double z, double sendRadius, double time, double amplitude) {
        Vec3 center = new Vec3(x, y, z);
        for (ServerPlayer serverPlayer : level.getEntitiesOfClass(ServerPlayer.class, new AABB(center, center).inflate(sendRadius), e -> true)) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new ShakeClientMessage(time, sendRadius, amplitude, x, y, z), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToNearbyPlayers(Entity source, double sendRadius, double time, double amplitude) {
        if (sendRadius <= 0.0 || time <= 0.0 || amplitude <= 0.0) {
            return;
        }
        ShakeClientMessage.sendToNearbyPlayers(source.level(), source.getX(), source.getY(), source.getZ(), sendRadius, time, amplitude);
    }
}

