/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record AimVillagerMessage(int villagerId) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<AimVillagerMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("aim_villager"));
    public static final StreamCodec<ByteBuf, AimVillagerMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, AimVillagerMessage::villagerId, AimVillagerMessage::new);

    public static void handler(AimVillagerMessage message, IPayloadContext context) {
        Player sender = context.player();
        Entity entity = sender.level().getEntity(message.villagerId);
        if (entity instanceof AbstractVillager) {
            AbstractVillager abstractVillager = (AbstractVillager)entity;
            if (entity instanceof Villager) {
                Villager villager = (Villager)entity;
                villager.getGossips().add(sender.getUUID(), GossipType.MINOR_NEGATIVE, 10);
            }
            abstractVillager.getBrain().setActiveActivityIfPossible(Activity.PANIC);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

