/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.MortarEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.ArtilleryEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public enum ArtilleryIndicatorFireMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<ArtilleryIndicatorFireMessage> TYPE;
    public static final StreamCodec<ByteBuf, ArtilleryIndicatorFireMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        if (player.getMainHandItem().is((Item)ModItems.MONITOR.get()) && player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            stack = player.getOffhandItem();
        }
        if (stack.is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
            CompoundTag mainTag = NBTTool.getTag(stack);
            ListTag tags = mainTag.getList("Cannons", 10);
            if (tags.isEmpty()) {
                mainTag.remove("Type");
                return;
            }
            for (int i = 0; i < tags.size(); ++i) {
                ArtilleryEntity artilleryEntity;
                GunData gunData;
                CompoundTag tag = tags.getCompound(i);
                Entity entity = EntityFindUtil.findEntity(player.level(), tag.getString("UUID"));
                if (!(entity instanceof ArtilleryEntity) || (gunData = (artilleryEntity = (ArtilleryEntity)entity).getGunData("Main")) == null) continue;
                if (entity instanceof MortarEntity) {
                    MortarEntity mortarEntity = (MortarEntity)entity;
                    Mod.queueServerWork(i % 5 + 1, () -> {
                        mortarEntity.vehicleShoot((LivingEntity)player, "Main");
                        mortarEntity.resetTarget("Main");
                    });
                    continue;
                }
                if (gunData.ammo.get() <= 0) continue;
                Mod.queueServerWork(i % 5 + 1, () -> {
                    artilleryEntity.vehicleShoot((LivingEntity)player, "Main");
                    artilleryEntity.resetTarget("Main");
                });
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("artillery_indicator_fire"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

