/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.init.ModItems;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record DogTagFinishEditMessage(List<Short> colors, String name, boolean mainHand) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DogTagFinishEditMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("dog_tag_finish_edit"));
    public static final StreamCodec<ByteBuf, DogTagFinishEditMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.SHORT.apply(ByteBufCodecs.list()), DogTagFinishEditMessage::colors, (StreamCodec)ByteBufCodecs.STRING_UTF8, DogTagFinishEditMessage::name, (StreamCodec)ByteBufCodecs.BOOL, DogTagFinishEditMessage::mainHand, DogTagFinishEditMessage::new);

    public static void handler(DogTagFinishEditMessage message, IPayloadContext context) {
        ItemStack stack;
        ServerPlayer serverPlayer = (ServerPlayer)context.player();
        ItemStack itemStack = stack = message.mainHand ? serverPlayer.getMainHandItem() : serverPlayer.getOffhandItem();
        if (!stack.is((Item)ModItems.DOG_TAG.get())) {
            return;
        }
        stack.set(ModDataComponents.DOG_TAG_IMAGE, message.colors);
        if (!message.name.isEmpty()) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)message.name));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

