/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.component.ModDataComponents;
import com.atsuishio.superbwarfare.entity.vehicle.DroneEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.ArtilleryIndicator;
import com.atsuishio.superbwarfare.item.FiringParameters;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record DroneFireMessage(Vector3f pos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DroneFireMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("drone_fire"));
    public static final StreamCodec<ByteBuf, DroneFireMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VECTOR3F, DroneFireMessage::pos, DroneFireMessage::new);

    public static void handler(DroneFireMessage message, IPayloadContext context) {
        DroneEntity drone;
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        CompoundTag mainTag = NBTTool.getTag(stack);
        if (stack.is((Item)ModItems.MONITOR.get()) && mainTag.getBoolean("Using") && mainTag.getBoolean("Linked") && (drone = EntityFindUtil.findDrone(player.level(), mainTag.getString("LinkedDrone"))) != null) {
            if (player.getOffhandItem().is((Item)ModItems.FIRING_PARAMETERS.get()) || player.getOffhandItem().is((Item)ModItems.ARTILLERY_INDICATOR.get())) {
                ItemStack offStack = player.getOffhandItem();
                FiringParameters.Parameters parameters = (FiringParameters.Parameters)offStack.get(ModDataComponents.FIRING_PARAMETERS);
                boolean isDepressed = false;
                int radius = 0;
                if (parameters != null) {
                    isDepressed = parameters.isDepressed();
                    radius = parameters.radius();
                }
                offStack.set(ModDataComponents.FIRING_PARAMETERS, (Object)new FiringParameters.Parameters(new BlockPos((int)message.pos.x, (int)message.pos.y, (int)message.pos.z), radius, isDepressed));
                player.displayClientMessage((Component)Component.translatable((String)"tips.superbwarfare.mortar.target_pos").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + message.pos.x() + "," + message.pos.y() + "," + message.pos.z() + "]"))), true);
                SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
                Item item = offStack.getItem();
                if (item instanceof ArtilleryIndicator) {
                    ArtilleryIndicator indicator = (ArtilleryIndicator)item;
                    indicator.setTarget(offStack, player);
                }
            } else {
                drone.fire = true;
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

