/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.value.AttachmentType;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.LivingEventHandler;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record EditMessage(int msgType, boolean add, boolean isVehicle) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("edit"));
    public static final StreamCodec<ByteBuf, EditMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, EditMessage::msgType, (StreamCodec)ByteBufCodecs.BOOL, EditMessage::add, (StreamCodec)ByteBufCodecs.BOOL, EditMessage::isVehicle, EditMessage::new);

    public static void handler(EditMessage message, IPayloadContext context) {
        EditMessage.pressAction(context.player(), message);
    }

    public static void pressAction(Player player, EditMessage message) {
        Entity entity;
        if (player == null) {
            return;
        }
        if (message.isVehicle && (entity = player.getVehicle()) instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            if (message.msgType != 5) {
                return;
            }
            vehicle.modifyGunData(vehicle.getSeatIndex((Entity)player), data -> {
                int size = data.getDefault().getAmmoConsumers().size();
                LivingEventHandler.stopGunReloadSound((ServerPlayer)player, data);
                data.changeAmmoConsumer((data.selectedAmmoType.get() + (message.add ? 1 : -1) + size) % size, vehicle.getAmmoSupplier());
                SoundEvent sound = data.compute().soundInfo.change;
                if (sound == null) {
                    return;
                }
                SoundTool.playLocalSound(player, sound, 4.0f, 1.0f);
            });
        } else {
            ItemStack stack = player.getMainHandItem();
            Item item = stack.getItem();
            if (!(item instanceof GunItem)) {
                return;
            }
            GunItem gunItem = (GunItem)item;
            GunData data2 = GunData.from(stack);
            switch (message.msgType) {
                case 0: {
                    int att = data2.attachment.get(AttachmentType.BARREL);
                    att = EditMessage.setAttachment(gunItem.getValidBarrels(), att, message.add);
                    data2.attachment.set(AttachmentType.BARREL, att);
                    break;
                }
                case 1: {
                    int att = data2.attachment.get(AttachmentType.SCOPE);
                    att = EditMessage.setAttachment(gunItem.getValidScopes(), att, message.add);
                    data2.attachment.set(AttachmentType.SCOPE, att);
                    break;
                }
                case 2: {
                    int att = data2.attachment.get(AttachmentType.GRIP);
                    att = EditMessage.setAttachment(gunItem.getValidGrips(), att, message.add);
                    data2.attachment.set(AttachmentType.GRIP, att);
                    break;
                }
                case 3: {
                    int att = data2.attachment.get(AttachmentType.STOCK);
                    att = EditMessage.setAttachment(gunItem.getValidStocks(), att, message.add);
                    data2.attachment.set(AttachmentType.STOCK, att);
                    break;
                }
                case 4: {
                    int att = data2.attachment.get(AttachmentType.MAGAZINE);
                    att = EditMessage.setAttachment(gunItem.getValidMagazines(), att, message.add);
                    data2.withdrawAmmo((Entity)player);
                    data2.attachment.set(AttachmentType.MAGAZINE, att);
                    break;
                }
                case 5: {
                    int size = data2.getDefault().getAmmoConsumers().size();
                    data2.changeAmmoConsumer((data2.selectedAmmoType.get() + (message.add ? 1 : -1) + size) % size, (Entity)player);
                }
            }
            data2.save();
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.EDIT.get(), 1.0f, 1.0f);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private static int setAttachment(int[] arr, int value, boolean add) {
        if (arr.length == 0) {
            return 0;
        }
        int[] sorted = Arrays.copyOf(arr, arr.length);
        Arrays.sort(sorted);
        int index = Arrays.binarySearch(sorted, value);
        if (index < 0) {
            index = -index - 1;
        }
        index = add ? (index + 1) % arr.length : (index + arr.length - 1) % arr.length;
        return sorted[index];
    }
}

