/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.event.GunEventHandler;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public enum ReloadMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<ReloadMessage> TYPE;
    public static final StreamCodec<ByteBuf, ReloadMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        ReloadMessage.pressAction(context.player());
    }

    public static void pressAction(Player player) {
        VehicleEntity vehicle;
        Entity entity = player.getVehicle();
        if (entity instanceof VehicleEntity && (vehicle = (VehicleEntity)entity).hasWeapon(vehicle.getSeatIndex((Entity)player))) {
            vehicle.modifyGunData(vehicle.getSeatIndex((Entity)player), data -> GunEventHandler.tryStartReload(vehicle.getAmmoSupplier(), data));
            return;
        }
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunEventHandler.tryStartReload((Entity)player, GunData.from(stack));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("reload"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

