/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public record ShootMessage(double spread, boolean zoom, Optional<UUID> uuid, Optional<Vector3f> targetPos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ShootMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("shoot"));
    public static final StreamCodec<ByteBuf, ShootMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.DOUBLE, ShootMessage::spread, (StreamCodec)ByteBufCodecs.BOOL, ShootMessage::zoom, (StreamCodec)ByteBufCodecs.optional((StreamCodec)UUIDUtil.STREAM_CODEC), ShootMessage::uuid, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.VECTOR3F), ShootMessage::targetPos, ShootMessage::new);

    public static void handler(ShootMessage message, IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        if (message.targetPos.isEmpty()) {
            GunData.from(stack).shoot((Entity)player, message.spread, message.zoom, message.uuid.orElse(null));
        } else {
            GunData.from(stack).shoot((Entity)player, message.spread, message.zoom, message.uuid.orElse(null), new Vec3(message.targetPos.get()));
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

