/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public enum UnloadMessage implements CustomPacketPayload
{
    INSTANCE;

    public static final CustomPacketPayload.Type<UnloadMessage> TYPE;
    public static final StreamCodec<ByteBuf, UnloadMessage> STREAM_CODEC;

    public static void handler(IPayloadContext context) {
        Player player = context.player();
        ItemStack stack = player.getMainHandItem();
        if (!(stack.getItem() instanceof GunItem)) {
            return;
        }
        GunData data = GunData.from(stack);
        data.withdrawAmmo((Entity)player);
        data.save();
        SoundTool.playLocalSound(player, (SoundEvent)ModSounds.EDIT.get(), 1.0f, 1.0f);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static {
        TYPE = new CustomPacketPayload.Type(Mod.loc("unload"));
        STREAM_CODEC = StreamCodec.unit((Object)((Object)INSTANCE));
    }
}

