/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.tools.EntityFindUtil;
import com.atsuishio.superbwarfare.tools.NBTTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record VehicleMovementMessage(short keys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<VehicleMovementMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("vehicle_movement"));
    public static final StreamCodec<ByteBuf, VehicleMovementMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.SHORT, VehicleMovementMessage::keys, VehicleMovementMessage::new);

    public static void handler(VehicleMovementMessage message, IPayloadContext context) {
        VehicleEntity vehicleEntity;
        ServerPlayer player = (ServerPlayer)context.player();
        Entity entity = player.getVehicle();
        ItemStack stack = player.getMainHandItem();
        CompoundTag tag = NBTTool.getTag(stack);
        VehicleEntity vehicle = null;
        if (entity instanceof VehicleEntity && (vehicleEntity = (VehicleEntity)entity).getFirstPassenger() == player) {
            vehicle = vehicleEntity;
        } else if (stack.is((Item)ModItems.MONITOR.get()) && tag.getBoolean("Using") && tag.getBoolean("Linked")) {
            vehicle = EntityFindUtil.findDrone(player.level(), tag.getString("LinkedDrone"));
        }
        if (vehicle == null) {
            return;
        }
        vehicle.processInput(message.keys);
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

