/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ZoomMessage(int msgType) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ZoomMessage> TYPE = new CustomPacketPayload.Type(Mod.loc("zoom"));
    public static final StreamCodec<ByteBuf, ZoomMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ZoomMessage::msgType, ZoomMessage::new);

    public static void handler(ZoomMessage message, IPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player();
        Entity entity = player.getVehicle();
        if (!(entity instanceof VehicleEntity)) {
            return;
        }
        VehicleEntity vehicle = (VehicleEntity)entity;
        if (message.msgType == 0 && vehicle.hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
        }
        if (message.msgType == 1 && vehicle.hasWeapon(vehicle.getSeatIndex((Entity)player)) && vehicle.banHand((LivingEntity)player)) {
            SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get(), 2.0f, 1.0f);
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

