/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk;

import com.atsuishio.superbwarfare.data.gun.DamageReduce;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunPropertyModifier;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.item.PerkItem;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class Perk
implements GunPropertyModifier {
    public final String descriptionId;
    public final String name;
    public final Type type;

    public Perk(String descriptionId, Type type) {
        this.descriptionId = descriptionId;
        this.type = type;
        StringBuilder builder = new StringBuilder();
        boolean useUpperCase = false;
        boolean isFirst = true;
        for (char c : descriptionId.toCharArray()) {
            if (isFirst || useUpperCase) {
                builder.append(String.valueOf(c).toUpperCase(Locale.ROOT));
                isFirst = false;
                useUpperCase = false;
                continue;
            }
            if (c == '_') {
                useUpperCase = true;
                continue;
            }
            builder.append(c);
        }
        this.name = builder.toString();
    }

    public DeferredHolder<Item, ? extends Item> getItem() {
        Optional<DeferredHolder> result = ModItems.PERKS.getEntries().stream().filter(p -> {
            Object patt0$temp = p.get();
            if (patt0$temp instanceof PerkItem) {
                PerkItem perkItem = (PerkItem)((Object)((Object)patt0$temp));
                return perkItem.getPerk() == this;
            }
            return false;
        }).findFirst();
        if (result.isEmpty()) {
            throw new IllegalStateException("Perk " + this.name + " not found");
        }
        return result.get();
    }

    public void tick(GunData data, PerkInstance instance, @Nullable Entity entity) {
    }

    public void preReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
    }

    public void postReload(GunData data, PerkInstance instance, @Nullable Entity entity) {
    }

    public void onKill(GunData data, PerkInstance instance, Entity target, DamageSource source) {
    }

    public void onHurtEntity(float damage, GunData data, PerkInstance instance, Entity target, DamageSource source) {
    }

    public void onHit(LivingEntity attacker, GunData data, PerkInstance instance, Entity target) {
    }

    public int getModifiedCustomRPM(int rpm, GunData data, PerkInstance instance) {
        return rpm;
    }

    public void onChangeSlot(GunData data, PerkInstance instance, @Nullable Entity living) {
    }

    public float getModifiedDamage(float damage, GunData data, PerkInstance instance, Entity target, DamageSource source) {
        return damage;
    }

    public void modifyProjectile(GunData data, PerkInstance instance, Entity entity) {
    }

    public double getModifiedDamageReduceRate(DamageReduce reduce) {
        return reduce.getRate();
    }

    public double getModifiedDamageReduceMinDistance(DamageReduce reduce) {
        return reduce.getMinDistance();
    }

    public void onMeleeAttack(GunData data, PerkInstance instance, Entity target) {
    }

    public static enum Type {
        AMMO("Ammo", ChatFormatting.YELLOW),
        FUNCTIONAL("Functional", ChatFormatting.GREEN),
        DAMAGE("Damage", ChatFormatting.RED);

        private final String name;
        private final ChatFormatting color;

        private Type(String type, ChatFormatting color) {
            this.name = type;
            this.color = color;
        }

        public String getName() {
            return this.name;
        }

        public ChatFormatting getColor() {
            return this.color;
        }
    }
}

