/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.perk.functional;

import com.atsuishio.superbwarfare.capability.player.PlayerVariable;
import com.atsuishio.superbwarfare.data.gun.DefaultGunData;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunType;
import com.atsuishio.superbwarfare.init.ModAttachments;
import com.atsuishio.superbwarfare.perk.Perk;
import com.atsuishio.superbwarfare.perk.PerkInstance;
import com.atsuishio.superbwarfare.tools.DamageTypeTool;
import com.atsuishio.superbwarfare.tools.InventoryTool;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;

public class Subsistence
extends Perk {
    public Subsistence() {
        super("subsistence", Perk.Type.FUNCTIONAL);
    }

    @Override
    public void onKill(GunData data, PerkInstance instance, Entity target, DamageSource source) {
        Projectile p;
        Entity entity;
        Player attacker = null;
        Entity entity2 = source.getEntity();
        if (entity2 instanceof Player) {
            Player player;
            attacker = player = (Player)entity2;
        }
        if ((entity = source.getDirectEntity()) instanceof Projectile && (entity = (p = (Projectile)entity).getOwner()) instanceof Player) {
            Player player;
            attacker = player = (Player)entity;
        }
        if (DamageTypeTool.isGunDamage(source) && attacker != null) {
            DefaultGunData computed = data.compute();
            GunType type = computed.gunType;
            float rate = (float)instance.level() * (0.1f + (type == GunType.SMG || type == GunType.RIFLE ? 0.07f : 0.0f));
            PlayerVariable cap = ((PlayerVariable)attacker.getData(ModAttachments.PLAYER_VARIABLE)).watch();
            int mag = computed.magazine;
            int ammo = data.ammo.get();
            int ammoReload = (int)Math.min((float)mag, (float)mag * rate);
            int ammoNeed = Math.min(mag - ammo, ammoReload);
            boolean flag = attacker.isCreative() || InventoryTool.hasCreativeAmmoBox((Entity)attacker);
            int ammoFinal = Math.min(data.countBackupAmmo((Entity)attacker), ammoNeed);
            if (flag) {
                ammoFinal = ammoNeed;
            } else {
                data.consumeBackupAmmo((Entity)attacker, ammoFinal);
            }
            data.ammo.set(Math.min(mag, ammo + ammoFinal));
            cap.sync((Entity)attacker);
        }
    }
}

