/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.data.gun.Ammo;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoBoxItem;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoSupplierItem;
import java.util.HashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxAddAmmoRecipe
extends CustomRecipe {
    public AmmoBoxAddAmmoRecipe(CraftingBookCategory pCategory) {
        super(pCategory);
    }

    public boolean matches(@NotNull CraftingInput input, @NotNull Level pLevel) {
        boolean hasAmmoBox = false;
        boolean hasAmmo = false;
        for (ItemStack item : input.items()) {
            if (item.getItem() instanceof AmmoBoxItem) {
                if (hasAmmoBox) {
                    return false;
                }
                hasAmmoBox = true;
                continue;
            }
            if (item.getItem() instanceof AmmoSupplierItem) {
                hasAmmo = true;
                continue;
            }
            if (item.isEmpty()) continue;
            return false;
        }
        return hasAmmoBox && hasAmmo;
    }

    private void addAmmo(HashMap<Ammo, Integer> map, Ammo type, int count) {
        map.put(type, map.getOrDefault((Object)type, 0) + count);
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        HashMap<Ammo, Integer> map = new HashMap<Ammo, Integer>();
        ItemStack ammoBox = ItemStack.EMPTY;
        for (ItemStack item : input.items()) {
            Ammo[] ammoArray = item.getItem();
            if (ammoArray instanceof AmmoSupplierItem) {
                AmmoSupplierItem ammoSupplier = (AmmoSupplierItem)ammoArray;
                this.addAmmo(map, ammoSupplier.type, ammoSupplier.ammoToAdd);
                continue;
            }
            if (!(item.getItem() instanceof AmmoBoxItem)) continue;
            ammoBox = item.copy();
            for (Ammo type : Ammo.values()) {
                this.addAmmo(map, type, type.get(item));
            }
        }
        for (Ammo type : Ammo.values()) {
            type.set(ammoBox, (int)map.getOrDefault((Object)type, 0));
        }
        return ammoBox;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.AMMO_BOX_ADD_AMMO_SERIALIZER.get();
    }
}

