/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.google.gson.annotations.SerializedName;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class VehicleAssemblingIngredient
implements DeserializeFromString {
    @SerializedName(value="ingredient")
    String ingredientString = "";
    @SerializedName(value="count")
    int count = 1;
    public static final Codec<VehicleAssemblingIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("ingredient").forGetter(i -> i.ingredientString), (App)Codec.INT.fieldOf("count").forGetter(i -> i.count)).apply((Applicative)builder, VehicleAssemblingIngredient::new)).codec();
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleAssemblingIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, i -> i.ingredientString, (StreamCodec)ByteBufCodecs.VAR_INT, i -> i.count, VehicleAssemblingIngredient::new);
    public transient Ingredient ingredientObject;
    private static final Pattern INGREDIENT_PATTERN = Pattern.compile("^(?<count>(\\d+)?)\\s*(x\\s*)?(?<prefix>#?)(?<id>\\w+:\\S+)$");

    public VehicleAssemblingIngredient() {
    }

    public VehicleAssemblingIngredient(String ingredientString, int count) {
        this.ingredientString = ingredientString;
        this.count = count;
    }

    public Ingredient getIngredient() {
        if (this.ingredientObject == null) {
            this.deserializeFromString(this.ingredientString);
        }
        return this.ingredientObject;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void deserializeFromString(String str) {
        this.ingredientString = str;
        Matcher matcher = INGREDIENT_PATTERN.matcher(str);
        if (!matcher.matches()) {
            Mod.LOGGER.warn("invalid vehicle assembling ingredient: {}", (Object)str);
            this.ingredientObject = Ingredient.EMPTY;
            return;
        }
        String countString = matcher.group("count");
        if (!countString.isEmpty()) {
            this.count = Math.max(1, Integer.parseInt(countString));
        }
        String id = matcher.group("id");
        this.ingredientObject = matcher.group("prefix").equals("#") ? Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)id))) : Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id))});
    }
}

