/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.resource.gun;

import com.atsuishio.superbwarfare.data.CustomData;
import com.atsuishio.superbwarfare.data.DefaultDataSupplier;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.resource.gun.DefaultGunResource;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class GunResource
implements DefaultDataSupplier<DefaultGunResource> {
    public static final LoadingCache<ItemStack, GunResource> RESOURCE_CACHE = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<ItemStack, GunResource>(){

        @NotNull
        public GunResource load(@NotNull ItemStack stack) {
            return new GunResource(stack);
        }
    });
    public final ItemStack stack;
    public final GunItem item;
    public final String id;
    private DefaultGunResource cache = null;

    private GunResource(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof GunItem)) {
            throw new IllegalArgumentException("stack is not GunItem!");
        }
        GunItem gunItem = (GunItem)item;
        this.item = gunItem;
        this.stack = stack;
        this.id = GunResource.getRegistryId(stack.getItem());
    }

    public static DefaultGunResource compute(ItemStack stack) {
        return GunResource.from(stack).compute();
    }

    public DefaultGunResource compute() {
        DefaultGunResource defaultResource;
        if (this.cache != null) {
            return this.cache;
        }
        this.cache = defaultResource = (DefaultGunResource)this.getDefault().copy();
        return defaultResource;
    }

    public void update() {
        this.cache = null;
    }

    public static DefaultGunResource getDefault(String id) {
        return CustomData.GUN_RESOURCE.getOrElseGet(id, DefaultGunResource::new);
    }

    @Override
    public DefaultGunResource getDefault() {
        return CustomData.GUN_RESOURCE.getOrElseGet(this.id, DefaultGunResource::new);
    }

    public static DefaultGunResource getDefault(ItemStack stack) {
        return GunResource.getDefault(stack.getItem());
    }

    public static DefaultGunResource getDefault(Item item) {
        return GunResource.getDefault(GunResource.getRegistryId(item));
    }

    public static GunResource create(Item item) {
        return GunResource.from(new ItemStack((ItemLike)item));
    }

    public static GunResource from(ItemStack stack) {
        return (GunResource)RESOURCE_CACHE.getUnchecked((Object)stack);
    }

    public static String getRegistryId(Item item) {
        String id = item.getDescriptionId();
        id = id.substring(id.indexOf(".") + 1).replace('.', ':');
        return id;
    }
}

