/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.annotation.ServerOnly;
import com.atsuishio.superbwarfare.data.DataLoader;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;

public class BufferSerializer {
    private static final Gson GSON = DataLoader.createCommonBuilder().addSerializationExclusionStrategy(new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(ServerOnly.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }).create();

    public static List<Field> sortedFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> !f.isAnnotationPresent(ServerOnly.class) && !Modifier.isTransient(f.getModifiers()) && !f.getType().isAssignableFrom(Annotation.class)).sorted(Comparator.comparing(Field::getName)).toList();
    }

    public static List<Field> sortedFields(Object object) {
        return BufferSerializer.sortedFields(object.getClass());
    }

    public static List<Pair<Object, Field>> fieldValuesList(Object object) {
        ArrayList<Pair<Object, Field>> fields = new ArrayList<Pair<Object, Field>>();
        for (Field field : BufferSerializer.sortedFields(object)) {
            try {
                field.setAccessible(true);
                Object value = field.get(object);
                fields.add((Pair<Object, Field>)new Pair(value, (Object)field));
            }
            catch (IllegalAccessException e) {
                Mod.LOGGER.error("BufferSerializer read error: {}", (Object)e.getMessage());
            }
        }
        return fields;
    }

    public static FriendlyByteBuf serialize(Object object) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        BufferSerializer.fieldValuesList(object).forEach(fieldValue -> {
            Object value = fieldValue.getFirst();
            Field field = (Field)fieldValue.getSecond();
            if (value == null) {
                buffer.writeUtf(GSON.toJson(null, field.getGenericType()));
            } else {
                Object object = value;
                Objects.requireNonNull(object);
                Object selector0$temp = object;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Integer.class, Long.class, Float.class, Double.class, String.class, Boolean.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Byte b = (Byte)selector0$temp;
                        buffer.writeByte(b.byteValue());
                        break;
                    }
                    case 1: {
                        Integer i = (Integer)selector0$temp;
                        buffer.writeVarInt(i.intValue());
                        break;
                    }
                    case 2: {
                        Long l = (Long)selector0$temp;
                        buffer.writeLong(l.longValue());
                        break;
                    }
                    case 3: {
                        Float f = (Float)selector0$temp;
                        buffer.writeFloat(f.floatValue());
                        break;
                    }
                    case 4: {
                        Double d = (Double)selector0$temp;
                        buffer.writeDouble(d.doubleValue());
                        break;
                    }
                    case 5: {
                        String s = (String)selector0$temp;
                        buffer.writeUtf(s);
                        break;
                    }
                    case 6: {
                        Boolean b = (Boolean)selector0$temp;
                        buffer.writeBoolean(b.booleanValue());
                        break;
                    }
                    default: {
                        buffer.writeUtf(GSON.toJson(value, field.getGenericType()));
                    }
                }
            }
        });
        return buffer;
    }

    public static <T> T deserialize(FriendlyByteBuf buffer, T object) {
        BufferSerializer.sortedFields(object).forEach(field -> {
            Class<?> classType = field.getType();
            if (Byte.TYPE.isAssignableFrom(classType) || Byte.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readByte());
            } else if (Integer.TYPE.isAssignableFrom(classType) || Integer.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readVarInt());
            } else if (Long.TYPE.isAssignableFrom(classType) || Long.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readLong());
            } else if (Float.TYPE.isAssignableFrom(classType) || Float.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, Float.valueOf(buffer.readFloat()));
            } else if (Double.TYPE.isAssignableFrom(classType) || Double.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readDouble());
            } else if (Boolean.TYPE.isAssignableFrom(classType) || Boolean.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readBoolean());
            } else if (String.class.isAssignableFrom(classType)) {
                BufferSerializer.setField(object, field, buffer.readUtf());
            } else {
                BufferSerializer.setField(object, field, GSON.fromJson(buffer.readUtf(), field.getGenericType()));
            }
        });
        return object;
    }

    public static void setField(Object object, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            Mod.LOGGER.error("BufferSerializer write error: {}", (Object)e.getMessage());
        }
    }
}

